/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.simantics.browsing.ui.swt.widgets.WidgetImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.SWTUtils;

public class Table
extends WidgetImpl {
    private ReadFactory<?, List<Pair<String, Object>>> itemFactory;
    private ReadFactory<?, String> selectionFactory;
    private CopyOnWriteArrayList<SelectionListener> selectionListeners = new CopyOnWriteArrayList();
    private final org.eclipse.swt.widgets.Table table;

    public Table(Composite parent, WidgetSupport support, int style) {
        super(support);
        this.table = new org.eclipse.swt.widgets.Table(parent, style);
        this.table.setData("org.simantics.browsing.ui.widgets.Combo", (Object)this);
        support.register(this);
    }

    public void setItemFactory(ReadFactory<?, List<Pair<String, Object>>> itemFactory) {
        this.itemFactory = itemFactory;
    }

    public void setSelectionFactory(ReadFactory<?, String> selectionFactory) {
        this.selectionFactory = selectionFactory;
    }

    public org.eclipse.swt.widgets.Table getWidget() {
        return this.table;
    }

    @Override
    public Control getControl() {
        return this.table;
    }

    @Override
    public void setInput(ISessionContext context, Object input) {
        if (this.selectionListeners != null) {
            for (SelectionListener listener : this.selectionListeners) {
                if (!(listener instanceof Widget)) continue;
                ((Widget)listener).setInput(context, input);
            }
        }
        if (this.itemFactory != null) {
            this.itemFactory.listen(context, input, new Listener<List<Pair<String, Object>>>(){

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public void execute(final List<Pair<String, Object>> items) {
                    SWTUtils.asyncExec((org.eclipse.swt.widgets.Widget)Table.this.table, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Integer selectionIndex;
                            if (this.isDisposed()) {
                                return;
                            }
                            for (SelectionListener listener : Table.this.selectionListeners) {
                                Table.this.table.removeSelectionListener(listener);
                            }
                            Table.this.table.setData((Object)items);
                            try {
                                Table.this.table.removeAll();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            for (Pair key : items) {
                                TableItem item = new TableItem(Table.this.table, 0);
                                item.setText((String)key.first);
                                item.setData(key.second);
                            }
                            String selectionKey = (String)Table.this.table.getData("_SelectionKey");
                            if (selectionKey != null && (selectionIndex = (Integer)Table.this.table.getData(selectionKey)) != null) {
                                Table.this.table.select(selectionIndex.intValue());
                            }
                            for (SelectionListener listener : Table.this.selectionListeners) {
                                Table.this.table.addSelectionListener(listener);
                            }
                        }
                    });
                }

                public boolean isDisposed() {
                    return Table.this.table.isDisposed();
                }
            });
        }
        if (this.selectionFactory != null) {
            this.selectionFactory.listen(context, input, new Listener<String>(){

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public void execute(final String selectionKey) {
                    SWTUtils.asyncExec((org.eclipse.swt.widgets.Widget)Table.this.table, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            if (selectionKey == null) {
                                return;
                            }
                            Table.this.table.setData("_SelectionKey", (Object)selectionKey);
                            Integer selectionIndex = (Integer)Table.this.table.getData(selectionKey);
                            if (selectionIndex != null) {
                                Table.this.table.select(selectionIndex.intValue());
                            }
                        }
                    });
                }

                public boolean isDisposed() {
                    return Table.this.table.isDisposed();
                }
            });
        }
    }

    public synchronized void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
        this.table.addSelectionListener(listener);
    }
}

