/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.simantics.browsing.ui.swt.widgets.WidgetImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Pair;

public class Combo
extends WidgetImpl {
    private ReadFactory<?, Map<String, Object>> itemFactory;
    private ReadFactory<?, List<Pair<String, Object>>> itemFactory2;
    private ReadFactory<?, String> selectionFactory;
    private final CopyOnWriteArrayList<ModifyListener> modifyListeners = new CopyOnWriteArrayList();
    private List<Pair<String, Object>> itemList;
    private final Display display;
    private final org.eclipse.swt.widgets.Combo combo;
    private AtomicBoolean inputDisposed;

    public Combo(Composite parent, WidgetSupport support, int style) {
        super(support);
        this.display = parent.getDisplay();
        this.combo = new org.eclipse.swt.widgets.Combo(parent, style);
        this.combo.setData("org.simantics.browsing.ui.widgets.Combo", (Object)this);
        support.register(this);
    }

    public void setItemFactory(ReadFactory<?, Map<String, Object>> itemFactory) {
        if (this.itemFactory2 != null) {
            throw new IllegalStateException("Cannot use both itemFactory and itemFactory2");
        }
        this.itemFactory = itemFactory;
    }

    public void setItemFactory2(ReadFactory<?, List<Pair<String, Object>>> itemFactory) {
        if (this.itemFactory != null) {
            throw new IllegalStateException("Cannot use both itemFactory and itemFactory2");
        }
        this.itemFactory2 = itemFactory;
    }

    public void setSelectionFactory(ReadFactory<?, String> selectionFactory) {
        this.selectionFactory = selectionFactory;
    }

    public org.eclipse.swt.widgets.Combo getWidget() {
        return this.combo;
    }

    @Override
    public Control getControl() {
        return this.combo;
    }

    @Override
    public void setInput(ISessionContext context, Object input) {
        if (this.inputDisposed != null) {
            this.inputDisposed.set(true);
        }
        final AtomicBoolean inputDisposed = this.inputDisposed = new AtomicBoolean(false);
        if (this.modifyListeners != null) {
            for (ModifyListener listener : this.modifyListeners) {
                if (!(listener instanceof Widget)) continue;
                ((Widget)listener).setInput(context, input);
            }
        }
        if (this.itemFactory != null) {
            this.itemFactory.listen(context, input, new Listener<Map<String, Object>>(){

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public void execute(final Map<String, Object> items) {
                    if (this.isDisposed()) {
                        return;
                    }
                    Combo.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Integer selectionIndex;
                            if (this.isDisposed()) {
                                return;
                            }
                            for (ModifyListener listener : Combo.this.modifyListeners) {
                                Combo.this.combo.removeModifyListener(listener);
                            }
                            Combo.this.combo.setData((Object)items);
                            Combo.this.combo.clearSelection();
                            try {
                                Combo.this.combo.removeAll();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            int index = 0;
                            for (String key : items.keySet()) {
                                Combo.this.combo.add(key);
                                Combo.this.combo.setData(key, (Object)index++);
                            }
                            String selectionKey = (String)Combo.this.combo.getData("_SelectionKey");
                            if (selectionKey != null && (selectionIndex = (Integer)Combo.this.combo.getData(selectionKey)) != null) {
                                Combo.this.combo.select(selectionIndex.intValue());
                            }
                            for (ModifyListener listener : Combo.this.modifyListeners) {
                                Combo.this.combo.addModifyListener(listener);
                            }
                        }
                    });
                }

                public boolean isDisposed() {
                    return Combo.this.combo.isDisposed() || inputDisposed.get();
                }
            });
        }
        if (this.itemFactory2 != null) {
            this.itemFactory2.listen(context, input, new Listener<List<Pair<String, Object>>>(){

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public void execute(final List<Pair<String, Object>> items) {
                    if (this.isDisposed()) {
                        return;
                    }
                    Combo.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            Combo.this.itemList = items;
                            for (ModifyListener listener : Combo.this.modifyListeners) {
                                Combo.this.combo.removeModifyListener(listener);
                            }
                            Combo.this.combo.setData((Object)items);
                            Combo.this.combo.clearSelection();
                            try {
                                Combo.this.combo.removeAll();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            if (items != null) {
                                Integer selectionIndex;
                                int index = 0;
                                for (Pair key : items) {
                                    Combo.this.combo.add((String)key.first);
                                    Combo.this.combo.setData((String)key.first, (Object)index++);
                                }
                                String selectionKey = (String)Combo.this.combo.getData("_SelectionKey");
                                if (selectionKey != null && (selectionIndex = (Integer)Combo.this.combo.getData(selectionKey)) != null) {
                                    Combo.this.combo.select(selectionIndex.intValue());
                                }
                            }
                            for (ModifyListener listener : Combo.this.modifyListeners) {
                                Combo.this.combo.addModifyListener(listener);
                            }
                        }
                    });
                }

                public boolean isDisposed() {
                    return Combo.this.combo.isDisposed() || inputDisposed.get();
                }
            });
        }
        if (this.selectionFactory != null) {
            this.selectionFactory.listen(context, input, new Listener<String>(){

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public void execute(final String selectionKey) {
                    if (this.isDisposed()) {
                        return;
                    }
                    Combo.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            if (selectionKey == null) {
                                return;
                            }
                            for (ModifyListener listener : Combo.this.modifyListeners) {
                                Combo.this.combo.removeModifyListener(listener);
                            }
                            Combo.this.combo.setData("_SelectionKey", (Object)selectionKey);
                            Integer selectionIndex = (Integer)Combo.this.combo.getData(selectionKey);
                            if (selectionIndex != null) {
                                Combo.this.combo.select(selectionIndex.intValue());
                            }
                            for (ModifyListener listener : Combo.this.modifyListeners) {
                                Combo.this.combo.addModifyListener(listener);
                            }
                        }
                    });
                }

                public boolean isDisposed() {
                    return Combo.this.combo.isDisposed() || inputDisposed.get();
                }
            });
        }
    }

    public synchronized void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
        this.combo.addModifyListener(listener);
    }

    public <T> Pair<String, T> getData(int index) {
        if (this.itemFactory != null) {
            new IllegalStateException("this method is only useful when used with Combo.setItemFactory2").printStackTrace();
        }
        if (index == -1) {
            return null;
        }
        return this.itemList.get(index);
    }

    public <T> Pair<String, T> getSelectedData() {
        return this.getData(this.combo.getSelectionIndex());
    }
}

