/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.processors.AbstractNodeQueryProcessor;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.content.ImageDecoratorFactory;

public class DefaultImageDecoratorsProcessor
extends AbstractNodeQueryProcessor<Collection<ImageDecorator>> {
    public Collection<ImageDecorator> query(NodeQueryManager manager, NodeContext context) {
        Collection factories = (Collection)manager.query(context, BuiltinKeys.SELECTED_IMAGE_DECORATOR_FACTORIES);
        if (factories.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImageDecorator> decorators = new ArrayList<ImageDecorator>(factories.size());
        for (ImageDecoratorFactory f : factories) {
            assert (f != null);
            ImageDecorator decorator = (ImageDecorator)manager.query(context, (NodeContext.PrimitiveQueryKey)new BuiltinKeys.ImageDecoratorKey(f));
            if (decorator == null) continue;
            decorators.add(decorator);
        }
        return decorators;
    }

    public String toString() {
        return "ImageDecoratorsProcessor";
    }

    public NodeContext.QueryKey<Collection<ImageDecorator>> getIdentifier() {
        return BuiltinKeys.IMAGE_DECORATORS;
    }
}

