/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.services.IDisposable;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.swt.ResourceSelectionFilter;
import org.simantics.browsing.ui.swt.WorkbenchSelectionFilter;

public class DefaultExplorerSelectionListener
implements ISelectionListener,
IDisposable {
    private static final boolean DEBUG = false;
    IWorkbenchPart owner;
    GraphExplorer explorer;
    WorkbenchSelectionFilter filter;

    public DefaultExplorerSelectionListener(IWorkbenchPart owner, GraphExplorer explorer) {
        this(owner, explorer, ResourceSelectionFilter.FILTER);
    }

    public DefaultExplorerSelectionListener(IWorkbenchPart owner, GraphExplorer explorer, WorkbenchSelectionFilter filter) {
        this.owner = owner;
        this.explorer = explorer;
        this.filter = filter;
    }

    public void dispose() {
        this.owner = null;
        this.explorer = null;
        this.filter = null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IPostSelectionProvider selectionProvider;
        GraphExplorer explorer;
        if (part == this.owner) {
            return;
        }
        ISelection s = selection;
        WorkbenchSelectionFilter filter = this.filter;
        if (filter != null) {
            s = filter.filterSelection(part, selection);
        }
        if (s != null && (explorer = this.explorer) != null && !explorer.isDisposed() && (selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class)) != null) {
            selectionProvider.setSelection(selection);
        }
    }
}

