/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets.impl;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.ui.ISelectionUtils;

abstract public class SelectionListenerImpl<T> implements SelectionListener, Widget {

	private ISessionContext context;
	private Object lastInput = null;
	
    final private Class<?> clazz;
	
	public SelectionListenerImpl(ISessionContext context) {
		this.context = context;
        clazz = ReflectionUtils.getSingleParameterType(getClass());
	}
	
	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	
	@Override
	public void widgetSelected(SelectionEvent e) {
		
		final Object input = lastInput;
		
		try {
		    @SuppressWarnings("unchecked")
            T single = (T) ISelectionUtils.filterSingleSelection((ISelection)input, clazz);
			beforeApply(single);
			
			context.getSession().syncRequest(new WriteRequest() {

				@SuppressWarnings("unchecked")
                @Override
				public void perform(WriteGraph graph) throws DatabaseException {
				    graph.markUndoPoint();
					T single = (T) ISelectionUtils.filterSingleSelection((ISelection)input, clazz);
					apply(graph, single);
				}
				
			});
		} catch (DatabaseException e1) {
			e1.printStackTrace();
		}
	}

	@Override
	public void setInput(ISessionContext context, Object parameter) {
		this.context = context;
		lastInput = parameter;
	}
	
	public void beforeApply() {
		
	}
	
    public void beforeApply(T input) {
        beforeApply();
    }

	abstract public void apply(WriteGraph graph, T input) throws DatabaseException;
	
}
	