/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets.impl;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.ui.ISelectionUtils;

abstract public class MouseListenerImpl<T> implements MouseListener, Widget {

	private ISessionContext context;
	private Object lastInput = null;
	protected T single;	
    final private Class<?> clazz;
	
	public MouseListenerImpl(ISessionContext context) {
		this.context = context;
        clazz = ReflectionUtils.getSingleParameterType(getClass());
	}
	
	@Override
	public void mouseDown(MouseEvent e) {
	}
	
	@Override
	public void mouseUp(MouseEvent e) {
	}
	
	@Override
	public void mouseDoubleClick(MouseEvent e) {
		
		final Object input = lastInput;
		
		
		try {

			single = (T) ISelectionUtils.filterSingleSelection((ISelection)input, clazz);
			
			beforeApply(single);
			
			context.getSession().syncRequest(new WriteRequest() {

				@SuppressWarnings("unchecked")
                @Override
				public void perform(WriteGraph graph) throws DatabaseException {

//					T single = (T) ISelectionUtils.filterSingleSelection((ISelection)input, clazz);
					doubleClick(graph, single);
					
				}
				
			});
		} catch (DatabaseException e1) {
			e1.printStackTrace();
		}
	}

	@Override
	public void setInput(ISessionContext context, Object parameter) {
		this.context = context;
		lastInput = parameter;
	}
	
	public void beforeApply(T input) {
		
	}
	
	abstract public void doubleClick(WriteGraph graph, T input) throws DatabaseException;
	
}
	