/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import java.util.concurrent.CopyOnWriteArrayList;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;

public class Scale extends WidgetImpl {

    private ReadFactory<?, Integer> selectionFactory;
    private final CopyOnWriteArrayList<SelectionListener> selectionListeners = new CopyOnWriteArrayList<SelectionListener>();

    final private Display display;
    final private org.eclipse.swt.widgets.Scale scale;

    public Scale(Composite parent, WidgetSupport support, int style) {
    	super(support);
        this.display = parent.getDisplay();
        scale = new org.eclipse.swt.widgets.Scale(parent, style);
        scale.setData("org.simantics.browsing.ui.widgets.Scale", this);
        support.register(this);
    }

    public void setSelectionFactory(ReadFactory<?, Integer> selectionFactory) {
        this.selectionFactory = selectionFactory;
    }

    public org.eclipse.swt.widgets.Scale getWidget() {
        return scale;
    }

    @Override
    public Control getControl() {
        return scale;
    }

    @Override
    public void setInput(ISessionContext context, Object input) {

        if (selectionListeners != null) {
            for (SelectionListener listener : selectionListeners) {
                if(listener instanceof Widget) {
                    ((Widget) listener).setInput(context, input);
                }
            }
        }

        if(selectionFactory != null) {
            selectionFactory.listen(context, input, new Listener<Integer>() {

                @Override
                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                @Override
                public void execute(final Integer selection) {
                    if(isDisposed()) return;
                    display.asyncExec(new Runnable() {

                        @Override
                        public void run() {
                            if(isDisposed()) return;
                            if(selection == null) return;
                            for(SelectionListener listener : selectionListeners) scale.removeSelectionListener(listener);
                            scale.setSelection(selection);
                            for(SelectionListener listener : selectionListeners) scale.addSelectionListener(listener);
                        }

                    });
                }

                @Override
                public boolean isDisposed() {
                    return scale.isDisposed();
                }

            });
        }

    }

    public synchronized void addSelectionListener(SelectionListener listener) {
        selectionListeners.add(listener);
        scale.addSelectionListener(listener);
    }

}
