/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

/**
 * @author Tuukka Lehtonen
 *
 * @param <T>
 */
public class NamedObjectContentProposalProvider<T extends INamedObject> implements IContentProposalProvider {

    private final Collection<T> content;

    public NamedObjectContentProposalProvider(T[] content) {
        this(Arrays.asList(content));
    }

    public NamedObjectContentProposalProvider(Collection<T> content) {
        this.content = content;
    }

    @Override
    public IContentProposal[] getProposals(String contents, int position) {
        String prefix = contents.substring(0, position).toLowerCase();

        List<INamedObject> result = new ArrayList<INamedObject>(content.size());
        for (INamedObject obj : content) {
            if (obj.getName().toLowerCase().startsWith(prefix))
                result.add(obj);
        }

        IContentProposal[] proposals = new IContentProposal[result.size()];
        for (int i = 0; i < result.size(); ++i)
            proposals[i] = createProposal(result.get(i), position);

        return proposals;
    }

    public INamedObjectContentProposal createProposal(INamedObject object, int position) {
        return new NamedObjectContentProposal((NamedObject<?>) object, position);
    }

}
