/*******************************************************************************
 * Copyright (c) 2010, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.contentassist;

/**
 * @author Tuukka Lehtonen
 */
public class NamedObject<T> implements INamedObject {

    private final T object;
    private final String name;
    private final String label;
    private final String description;

    public NamedObject(T object, String name) {
        this(object, name, name);
    }

    public NamedObject(T object, String name, String label) {
        this(object, name, label, null);
    }

    public NamedObject(T object, String name, String label, String description) {
        this.object = object;
        this.name = name;
        this.label = label;
        this.description = description;
    }

    @Override
    public String getName() {
        return name;
    }

    public String getLabel() {
        return label;
    }

    public String getDescription() {
        return description;
    }

    public T getObject() {
        return object;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((object == null) ? 0 : object.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        NamedObject<?> other = (NamedObject<?>) obj;
        if (object == null) {
            if (other.object != null)
                return false;
        } else if (!object.equals(other.object))
            return false;
        return true;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[name=" + name + "]";
    }

}
