/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.common.internal.UIElementReference;

/**
 * @author Tuukka Lehtonen
 */
public class TreeItemReference implements UIElementReference {

    private final TreeItem item;

    public static TreeItemReference create(TreeItem item) {
        return new TreeItemReference(item);
    }

    private TreeItemReference(TreeItem item) {
        this.item = item;
    }

    public TreeItem getItem() {
        return item;
    }

    @Override
    public boolean hasReference() {
        return item != null;
    }

    @Override
    public boolean isDisposed() {
        if (item == null)
            return true;
        return item.isDisposed();
    }

    @Override
    public String toString() {
        if (item == null)
            return "(" + String.valueOf(System.identityHashCode(this)) + ":no item)";
        return "(" + String.valueOf(System.identityHashCode(this)) + ":TreeItem@" + System.identityHashCode(item) + ")";
    }

}
