/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.views.PropertyTableConstants;
import org.simantics.db.Session;
import org.simantics.db.management.ISessionContext;
import org.simantics.ui.dnd.BasicDragSource;
import org.simantics.ui.dnd.SessionContainer;

public class PropertyTableUtil {

    /**
     * @param explorer
     * @return the object representing the drag source. If the object implements
     *         {@link SessionContainer}, its
     *         {@link SessionContainer#setSession(Session)} will be invoked
     *         every time the active database session changes.
     */
    public static Object createResourceDragSource(GraphExplorer explorer) {
        ISelectionProvider selectionProvider = (ISelectionProvider)explorer.getAdapter(ISelectionProvider.class);
        Control control = explorer.getControl();
        return new BasicDragSource(selectionProvider, control, null, PropertyTableConstants.DND_PURPOSE_PROPERTY);
    }

    public static void setupDragSource(Object dragSource, ISessionContext sessionContext) {
        if (dragSource instanceof SessionContainer) {
            ((SessionContainer) dragSource).setSession(sessionContext != null ? sessionContext.getSession() : null);
        }
    }

}
