/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Control;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.action.IPriorityAction;

/**
 * An abstract base class for implementing SWT mouse event handlers for
 * SWT-based {@link GraphExplorer}.
 * 
 * <p>
 * Use {@link #getClickedContext(MouseEvent)} to find the possible NodeContext
 * the user clicked. You may also reimplement
 * {@link #handleContextDoubleClick(NodeContext)} for the easiest way to
 * redefine double click handling.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see IPriorityAction
 */
public class GraphExplorerMouseAdapter extends MouseAdapter {

    protected GraphExplorer ge;

    public GraphExplorerMouseAdapter(GraphExplorer ge) {
        this.ge = ge;
    }

    protected ISelection getClickedContext(MouseEvent e) {
//        final Tree tree = (Tree) e.getSource();
//        Point point = new Point(e.x, e.y);
//        TreeItem item = tree.getItem(point);
//
//        // No selectable item at point?
//        if (item == null)
//            return null;
//
//        Object data = item.getData();
    	Object data = ge.getClicked(e);
    	if (data == null)
    		return null;
    	
        NodeContext context = AdaptionUtils.adaptToSingle(data, NodeContext.class);
        if (context == null)
            return null;
        //System.out.println("double clicked tree item data: " + data);

        ISelectionProvider sp = (ISelectionProvider) ge.getAdapter(ISelectionProvider.class);
        ISelection selection = sp.getSelection();
        //System.out.println("double clicked tree selection: " + selection);

        // Validate that the selection matches the clicked data.
        NodeContext selectionContext = AdaptionUtils.adaptToSingle(selection, NodeContext.class);
        if (!context.equals(selectionContext)) {
            //ErrorLogger.defaultLogWarning("GraphExplorer selection does not match clicked tree item's NodeContext", new Exception("stacktrace"));
            return new StructuredSelection(context);
        }

        return selection;
    }

    @Override
    public void mouseDoubleClick(MouseEvent e) {
        ISelection context = getClickedContext(e);
        if (context == null)
            return;

        Control tree = (Control)e.getSource();
        handleContextDoubleClick(tree, context);
    }

    protected void handleContextDoubleClick(Control tree, ISelection selection) {
    }

}
