/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.net.URL;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.Pair;

/**
 * @author Antti Villberg
 */
public class BundleIcon implements ModelledIcon {

    private final Resource       configuration;
    private Pair<String, String> location;

    public BundleIcon(ReadGraph graph, Resource configuration) throws DatabaseException {
        this.configuration = configuration;
        this.location = graph.syncRequest(new Location(configuration));
    }

    @Override
    public ImageDescriptor create() throws DatabaseException {
        Pair<String, String> bundleAndPath = Simantics.getSession().syncRequest(new Location(configuration));
        if (bundleAndPath == null)
            return null;

        Bundle bundle = Platform.getBundle(bundleAndPath.first);
        if (bundle == null)
            return null;
        URL url = bundle.getEntry(bundleAndPath.second);
        return ImageDescriptor.createFromURL(url);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + location + "]";
    }

    static class Location implements Read<Pair<String, String>> {
        Resource configuration;
        public Location(Resource configuration) {
            this.configuration = configuration;
        }
        @Override
        public Pair<String, String> perform(ReadGraph graph) throws DatabaseException {
            BrowsingResource BRO = BrowsingResource.getInstance(graph);
            String bundle = graph.getPossibleRelatedValue(configuration, BRO.BundleIcon_Bundle);
            if (bundle == null)
                return null;
            String path = graph.getPossibleRelatedValue(configuration, BRO.BundleIcon_Path);
            if (path == null)
                return null;
            return Pair.make(bundle, path);
        }
    }

}
