/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.browsing.ui.swt.internal.Threads;

/**
 * The activator class controls the plug-in life cycle.
 */
public class Activator extends Plugin {

    // The plug-in ID
    public static final String PLUGIN_ID = "org.simantics.browsing.ui.swt";

    // The shared instance
    private static Activator plugin;

    public static ImageDescriptor PDF_ICON;
    public static ImageDescriptor EDIT_ICON;
    public static ImageDescriptor HEADING1_ICON;
    public static ImageDescriptor BOLD_ICON;
    public static ImageDescriptor BULLETS_ICON;
    
    /**
     * The constructor
     */
    public Activator() {
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
     */
    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;

        Threads.initialize();

        Bundle bundle = context.getBundle();

        PDF_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/page_white_acrobat.png"));
        EDIT_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/page_edit.png"));
        HEADING1_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/text_heading_1.png"));
        BOLD_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/text_bold.png"));
        BULLETS_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/text_list_bullets.png"));
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
     */
    @Override
    public void stop(BundleContext context) throws Exception {
        Threads.shutdown();

        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

}
