package org.simantics.browsing.ui.swt.stubs;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class BrowsingResource {
    
    public final Resource Action;
    public final Resource BundleIcon;
    public final Resource BundleIcon_Bundle;
    public final Resource BundleIcon_Bundle_Inverse;
    public final Resource BundleIcon_Path;
    public final Resource BundleIcon_Path_Inverse;
    public final Resource Button;
    public final Resource Button_Action;
    public final Resource Button_Action_Inverse;
    public final Resource Button_Icon;
    public final Resource Button_Icon_Inverse;
    public final Resource Button_Text;
    public final Resource Button_Text_Inverse;
    public final Resource Button_Tooltip;
    public final Resource Button_Tooltip_Inverse;
    public final Resource Combo;
    public final Resource Combo_AvailableItems;
    public final Resource Combo_AvailableItems_Inverse;
    public final Resource Combo_Modifier;
    public final Resource Combo_Modifier_Inverse;
    public final Resource Combo_SelectedItem;
    public final Resource Combo_SelectedItem_Inverse;
    public final Resource Composite;
    public final Resource Composite_Children;
    public final Resource Composite_Children_Inverse;
    public final Resource Composite_ColumnCount;
    public final Resource Composite_ColumnCount_Inverse;
    public final Resource Control;
    public final Resource Control_HorizontalGrab;
    public final Resource Control_HorizontalGrab_Inverse;
    public final Resource Control_HorizontalSpan;
    public final Resource Control_HorizontalSpan_Inverse;
    public final Resource Control_PreferredHeight;
    public final Resource Control_PreferredHeight_Inverse;
    public final Resource Control_PreferredWidth;
    public final Resource Control_PreferredWidth_Inverse;
    public final Resource Dialog;
    public final Resource Dialog_Control;
    public final Resource Dialog_Control_Inverse;
    public final Resource Dialog_FinishAction;
    public final Resource Dialog_FinishAction_Inverse;
    public final Resource Dialog_Title;
    public final Resource Dialog_Title_Inverse;
    public final Resource GraphExplorerComposite;
    public final Resource GraphExplorerComposite_BrowseContext;
    public final Resource GraphExplorerComposite_BrowseContext_Inverse;
    public final Resource GraphExplorerComposite_Check;
    public final Resource GraphExplorerComposite_Check_Inverse;
    public final Resource GraphExplorerComposite_DisplayFilter;
    public final Resource GraphExplorerComposite_DisplayFilter_Inverse;
    public final Resource GraphExplorerComposite_SelectionListener;
    public final Resource GraphExplorerComposite_SelectionListener_Inverse;
    public final Resource GraphExplorerComposite_SelectionParameter;
    public final Resource GraphExplorerComposite_SelectionParameter_Inverse;
    public final Resource HasInputSource;
    public final Resource HasInputSource_Inverse;
    public final Resource Icon;
    public final Resource InputSource;
    public final Resource Listener;
    public final Resource ModifyListener;
    public final Resource Parameter;
    public final Resource ReadFactory;
    public final Resource Wizard;
    public final Resource WizardPage;
    public final Resource WizardPage_Control;
    public final Resource WizardPage_Control_Inverse;
    public final Resource WizardPage_Title;
    public final Resource WizardPage_Title_Inverse;
    public final Resource Wizard_FinishAction;
    public final Resource Wizard_FinishAction_Inverse;
    public final Resource Wizard_Pages;
    public final Resource Wizard_Pages_Inverse;
    public final Resource Wizard_Title;
    public final Resource Wizard_Title_Inverse;
    public final Resource WorkbenchSelectionInputSource;
    public final Resource WorkbenchSelectionResourceInputSource;
        
    public static class URIs {
        public static final String Action = "http://www.simantics.org/Browsing-1.1/Action";
        public static final String BundleIcon = "http://www.simantics.org/Browsing-1.1/BundleIcon";
        public static final String BundleIcon_Bundle = "http://www.simantics.org/Browsing-1.1/BundleIcon/Bundle";
        public static final String BundleIcon_Bundle_Inverse = "http://www.simantics.org/Browsing-1.1/BundleIcon/Bundle/Inverse";
        public static final String BundleIcon_Path = "http://www.simantics.org/Browsing-1.1/BundleIcon/Path";
        public static final String BundleIcon_Path_Inverse = "http://www.simantics.org/Browsing-1.1/BundleIcon/Path/Inverse";
        public static final String Button = "http://www.simantics.org/Browsing-1.1/Button";
        public static final String Button_Action = "http://www.simantics.org/Browsing-1.1/Button/Action";
        public static final String Button_Action_Inverse = "http://www.simantics.org/Browsing-1.1/Button/Action/Inverse";
        public static final String Button_Icon = "http://www.simantics.org/Browsing-1.1/Button/Icon";
        public static final String Button_Icon_Inverse = "http://www.simantics.org/Browsing-1.1/Button/Icon/Inverse";
        public static final String Button_Text = "http://www.simantics.org/Browsing-1.1/Button/Text";
        public static final String Button_Text_Inverse = "http://www.simantics.org/Browsing-1.1/Button/Text/Inverse";
        public static final String Button_Tooltip = "http://www.simantics.org/Browsing-1.1/Button/Tooltip";
        public static final String Button_Tooltip_Inverse = "http://www.simantics.org/Browsing-1.1/Button/Tooltip/Inverse";
        public static final String Combo = "http://www.simantics.org/Browsing-1.1/Combo";
        public static final String Combo_AvailableItems = "http://www.simantics.org/Browsing-1.1/Combo/AvailableItems";
        public static final String Combo_AvailableItems_Inverse = "http://www.simantics.org/Browsing-1.1/Combo/AvailableItems/Inverse";
        public static final String Combo_Modifier = "http://www.simantics.org/Browsing-1.1/Combo/Modifier";
        public static final String Combo_Modifier_Inverse = "http://www.simantics.org/Browsing-1.1/Combo/Modifier/Inverse";
        public static final String Combo_SelectedItem = "http://www.simantics.org/Browsing-1.1/Combo/SelectedItem";
        public static final String Combo_SelectedItem_Inverse = "http://www.simantics.org/Browsing-1.1/Combo/SelectedItem/Inverse";
        public static final String Composite = "http://www.simantics.org/Browsing-1.1/Composite";
        public static final String Composite_Children = "http://www.simantics.org/Browsing-1.1/Composite/Children";
        public static final String Composite_Children_Inverse = "http://www.simantics.org/Browsing-1.1/Composite/Children/Inverse";
        public static final String Composite_ColumnCount = "http://www.simantics.org/Browsing-1.1/Composite/ColumnCount";
        public static final String Composite_ColumnCount_Inverse = "http://www.simantics.org/Browsing-1.1/Composite/ColumnCount/Inverse";
        public static final String Control = "http://www.simantics.org/Browsing-1.1/Control";
        public static final String Control_HorizontalGrab = "http://www.simantics.org/Browsing-1.1/Control/HorizontalGrab";
        public static final String Control_HorizontalGrab_Inverse = "http://www.simantics.org/Browsing-1.1/Control/HorizontalGrab/Inverse";
        public static final String Control_HorizontalSpan = "http://www.simantics.org/Browsing-1.1/Control/HorizontalSpan";
        public static final String Control_HorizontalSpan_Inverse = "http://www.simantics.org/Browsing-1.1/Control/HorizontalSpan/Inverse";
        public static final String Control_PreferredHeight = "http://www.simantics.org/Browsing-1.1/Control/PreferredHeight";
        public static final String Control_PreferredHeight_Inverse = "http://www.simantics.org/Browsing-1.1/Control/PreferredHeight/Inverse";
        public static final String Control_PreferredWidth = "http://www.simantics.org/Browsing-1.1/Control/PreferredWidth";
        public static final String Control_PreferredWidth_Inverse = "http://www.simantics.org/Browsing-1.1/Control/PreferredWidth/Inverse";
        public static final String Dialog = "http://www.simantics.org/Browsing-1.1/Dialog";
        public static final String Dialog_Control = "http://www.simantics.org/Browsing-1.1/Dialog/Control";
        public static final String Dialog_Control_Inverse = "http://www.simantics.org/Browsing-1.1/Dialog/Control/Inverse";
        public static final String Dialog_FinishAction = "http://www.simantics.org/Browsing-1.1/Dialog/FinishAction";
        public static final String Dialog_FinishAction_Inverse = "http://www.simantics.org/Browsing-1.1/Dialog/FinishAction/Inverse";
        public static final String Dialog_Title = "http://www.simantics.org/Browsing-1.1/Dialog/Title";
        public static final String Dialog_Title_Inverse = "http://www.simantics.org/Browsing-1.1/Dialog/Title/Inverse";
        public static final String GraphExplorerComposite = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite";
        public static final String GraphExplorerComposite_BrowseContext = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite/BrowseContext";
        public static final String GraphExplorerComposite_BrowseContext_Inverse = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite/BrowseContext/Inverse";
        public static final String GraphExplorerComposite_Check = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite/Check";
        public static final String GraphExplorerComposite_Check_Inverse = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite/Check/Inverse";
        public static final String GraphExplorerComposite_DisplayFilter = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite/DisplayFilter";
        public static final String GraphExplorerComposite_DisplayFilter_Inverse = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite/DisplayFilter/Inverse";
        public static final String GraphExplorerComposite_SelectionListener = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite/SelectionListener";
        public static final String GraphExplorerComposite_SelectionListener_Inverse = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite/SelectionListener/Inverse";
        public static final String GraphExplorerComposite_SelectionParameter = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite/SelectionParameter";
        public static final String GraphExplorerComposite_SelectionParameter_Inverse = "http://www.simantics.org/Browsing-1.1/GraphExplorerComposite/SelectionParameter/Inverse";
        public static final String HasInputSource = "http://www.simantics.org/Browsing-1.1/HasInputSource";
        public static final String HasInputSource_Inverse = "http://www.simantics.org/Browsing-1.1/HasInputSource/Inverse";
        public static final String Icon = "http://www.simantics.org/Browsing-1.1/Icon";
        public static final String InputSource = "http://www.simantics.org/Browsing-1.1/InputSource";
        public static final String Listener = "http://www.simantics.org/Browsing-1.1/Listener";
        public static final String ModifyListener = "http://www.simantics.org/Browsing-1.1/ModifyListener";
        public static final String Parameter = "http://www.simantics.org/Browsing-1.1/Parameter";
        public static final String ReadFactory = "http://www.simantics.org/Browsing-1.1/ReadFactory";
        public static final String Wizard = "http://www.simantics.org/Browsing-1.1/Wizard";
        public static final String WizardPage = "http://www.simantics.org/Browsing-1.1/WizardPage";
        public static final String WizardPage_Control = "http://www.simantics.org/Browsing-1.1/WizardPage/Control";
        public static final String WizardPage_Control_Inverse = "http://www.simantics.org/Browsing-1.1/WizardPage/Control/Inverse";
        public static final String WizardPage_Title = "http://www.simantics.org/Browsing-1.1/WizardPage/Title";
        public static final String WizardPage_Title_Inverse = "http://www.simantics.org/Browsing-1.1/WizardPage/Title/Inverse";
        public static final String Wizard_FinishAction = "http://www.simantics.org/Browsing-1.1/Wizard/FinishAction";
        public static final String Wizard_FinishAction_Inverse = "http://www.simantics.org/Browsing-1.1/Wizard/FinishAction/Inverse";
        public static final String Wizard_Pages = "http://www.simantics.org/Browsing-1.1/Wizard/Pages";
        public static final String Wizard_Pages_Inverse = "http://www.simantics.org/Browsing-1.1/Wizard/Pages/Inverse";
        public static final String Wizard_Title = "http://www.simantics.org/Browsing-1.1/Wizard/Title";
        public static final String Wizard_Title_Inverse = "http://www.simantics.org/Browsing-1.1/Wizard/Title/Inverse";
        public static final String WorkbenchSelectionInputSource = "http://www.simantics.org/Browsing-1.1/WorkbenchSelectionInputSource";
        public static final String WorkbenchSelectionResourceInputSource = "http://www.simantics.org/Browsing-1.1/WorkbenchSelectionResourceInputSource";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public BrowsingResource(ReadGraph graph) {
        Action = getResourceOrNull(graph, URIs.Action);
        BundleIcon = getResourceOrNull(graph, URIs.BundleIcon);
        BundleIcon_Bundle = getResourceOrNull(graph, URIs.BundleIcon_Bundle);
        BundleIcon_Bundle_Inverse = getResourceOrNull(graph, URIs.BundleIcon_Bundle_Inverse);
        BundleIcon_Path = getResourceOrNull(graph, URIs.BundleIcon_Path);
        BundleIcon_Path_Inverse = getResourceOrNull(graph, URIs.BundleIcon_Path_Inverse);
        Button = getResourceOrNull(graph, URIs.Button);
        Button_Action = getResourceOrNull(graph, URIs.Button_Action);
        Button_Action_Inverse = getResourceOrNull(graph, URIs.Button_Action_Inverse);
        Button_Icon = getResourceOrNull(graph, URIs.Button_Icon);
        Button_Icon_Inverse = getResourceOrNull(graph, URIs.Button_Icon_Inverse);
        Button_Text = getResourceOrNull(graph, URIs.Button_Text);
        Button_Text_Inverse = getResourceOrNull(graph, URIs.Button_Text_Inverse);
        Button_Tooltip = getResourceOrNull(graph, URIs.Button_Tooltip);
        Button_Tooltip_Inverse = getResourceOrNull(graph, URIs.Button_Tooltip_Inverse);
        Combo = getResourceOrNull(graph, URIs.Combo);
        Combo_AvailableItems = getResourceOrNull(graph, URIs.Combo_AvailableItems);
        Combo_AvailableItems_Inverse = getResourceOrNull(graph, URIs.Combo_AvailableItems_Inverse);
        Combo_Modifier = getResourceOrNull(graph, URIs.Combo_Modifier);
        Combo_Modifier_Inverse = getResourceOrNull(graph, URIs.Combo_Modifier_Inverse);
        Combo_SelectedItem = getResourceOrNull(graph, URIs.Combo_SelectedItem);
        Combo_SelectedItem_Inverse = getResourceOrNull(graph, URIs.Combo_SelectedItem_Inverse);
        Composite = getResourceOrNull(graph, URIs.Composite);
        Composite_Children = getResourceOrNull(graph, URIs.Composite_Children);
        Composite_Children_Inverse = getResourceOrNull(graph, URIs.Composite_Children_Inverse);
        Composite_ColumnCount = getResourceOrNull(graph, URIs.Composite_ColumnCount);
        Composite_ColumnCount_Inverse = getResourceOrNull(graph, URIs.Composite_ColumnCount_Inverse);
        Control = getResourceOrNull(graph, URIs.Control);
        Control_HorizontalGrab = getResourceOrNull(graph, URIs.Control_HorizontalGrab);
        Control_HorizontalGrab_Inverse = getResourceOrNull(graph, URIs.Control_HorizontalGrab_Inverse);
        Control_HorizontalSpan = getResourceOrNull(graph, URIs.Control_HorizontalSpan);
        Control_HorizontalSpan_Inverse = getResourceOrNull(graph, URIs.Control_HorizontalSpan_Inverse);
        Control_PreferredHeight = getResourceOrNull(graph, URIs.Control_PreferredHeight);
        Control_PreferredHeight_Inverse = getResourceOrNull(graph, URIs.Control_PreferredHeight_Inverse);
        Control_PreferredWidth = getResourceOrNull(graph, URIs.Control_PreferredWidth);
        Control_PreferredWidth_Inverse = getResourceOrNull(graph, URIs.Control_PreferredWidth_Inverse);
        Dialog = getResourceOrNull(graph, URIs.Dialog);
        Dialog_Control = getResourceOrNull(graph, URIs.Dialog_Control);
        Dialog_Control_Inverse = getResourceOrNull(graph, URIs.Dialog_Control_Inverse);
        Dialog_FinishAction = getResourceOrNull(graph, URIs.Dialog_FinishAction);
        Dialog_FinishAction_Inverse = getResourceOrNull(graph, URIs.Dialog_FinishAction_Inverse);
        Dialog_Title = getResourceOrNull(graph, URIs.Dialog_Title);
        Dialog_Title_Inverse = getResourceOrNull(graph, URIs.Dialog_Title_Inverse);
        GraphExplorerComposite = getResourceOrNull(graph, URIs.GraphExplorerComposite);
        GraphExplorerComposite_BrowseContext = getResourceOrNull(graph, URIs.GraphExplorerComposite_BrowseContext);
        GraphExplorerComposite_BrowseContext_Inverse = getResourceOrNull(graph, URIs.GraphExplorerComposite_BrowseContext_Inverse);
        GraphExplorerComposite_Check = getResourceOrNull(graph, URIs.GraphExplorerComposite_Check);
        GraphExplorerComposite_Check_Inverse = getResourceOrNull(graph, URIs.GraphExplorerComposite_Check_Inverse);
        GraphExplorerComposite_DisplayFilter = getResourceOrNull(graph, URIs.GraphExplorerComposite_DisplayFilter);
        GraphExplorerComposite_DisplayFilter_Inverse = getResourceOrNull(graph, URIs.GraphExplorerComposite_DisplayFilter_Inverse);
        GraphExplorerComposite_SelectionListener = getResourceOrNull(graph, URIs.GraphExplorerComposite_SelectionListener);
        GraphExplorerComposite_SelectionListener_Inverse = getResourceOrNull(graph, URIs.GraphExplorerComposite_SelectionListener_Inverse);
        GraphExplorerComposite_SelectionParameter = getResourceOrNull(graph, URIs.GraphExplorerComposite_SelectionParameter);
        GraphExplorerComposite_SelectionParameter_Inverse = getResourceOrNull(graph, URIs.GraphExplorerComposite_SelectionParameter_Inverse);
        HasInputSource = getResourceOrNull(graph, URIs.HasInputSource);
        HasInputSource_Inverse = getResourceOrNull(graph, URIs.HasInputSource_Inverse);
        Icon = getResourceOrNull(graph, URIs.Icon);
        InputSource = getResourceOrNull(graph, URIs.InputSource);
        Listener = getResourceOrNull(graph, URIs.Listener);
        ModifyListener = getResourceOrNull(graph, URIs.ModifyListener);
        Parameter = getResourceOrNull(graph, URIs.Parameter);
        ReadFactory = getResourceOrNull(graph, URIs.ReadFactory);
        Wizard = getResourceOrNull(graph, URIs.Wizard);
        WizardPage = getResourceOrNull(graph, URIs.WizardPage);
        WizardPage_Control = getResourceOrNull(graph, URIs.WizardPage_Control);
        WizardPage_Control_Inverse = getResourceOrNull(graph, URIs.WizardPage_Control_Inverse);
        WizardPage_Title = getResourceOrNull(graph, URIs.WizardPage_Title);
        WizardPage_Title_Inverse = getResourceOrNull(graph, URIs.WizardPage_Title_Inverse);
        Wizard_FinishAction = getResourceOrNull(graph, URIs.Wizard_FinishAction);
        Wizard_FinishAction_Inverse = getResourceOrNull(graph, URIs.Wizard_FinishAction_Inverse);
        Wizard_Pages = getResourceOrNull(graph, URIs.Wizard_Pages);
        Wizard_Pages_Inverse = getResourceOrNull(graph, URIs.Wizard_Pages_Inverse);
        Wizard_Title = getResourceOrNull(graph, URIs.Wizard_Title);
        Wizard_Title_Inverse = getResourceOrNull(graph, URIs.Wizard_Title_Inverse);
        WorkbenchSelectionInputSource = getResourceOrNull(graph, URIs.WorkbenchSelectionInputSource);
        WorkbenchSelectionResourceInputSource = getResourceOrNull(graph, URIs.WorkbenchSelectionResourceInputSource);
    }
    
    public static BrowsingResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        BrowsingResource ret = session.peekService(BrowsingResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new BrowsingResource(qc.getIndependentGraph(graph));
            session.registerService(BrowsingResource.class, ret);
        }
        return ret;
    }
    
    public static BrowsingResource getInstance(RequestProcessor session) throws DatabaseException {
        BrowsingResource ret = session.peekService(BrowsingResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<BrowsingResource>() {
                public BrowsingResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new BrowsingResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(BrowsingResource.class, ret);
        }
        return ret;
    }
    
}

