/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.modifiers;

import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.InputValidator;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableWrite;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.scl.runtime.function.Function1;

public class VariableModifier2
implements Labeler.Modifier {
    protected final Session session;
    protected final Variable variable;
    private String initialValue;
    protected Throwable modifierFailed;
    protected InputValidator variableInputValidator;

    public VariableModifier2(RequestProcessor processor, Variable variable) {
        this.variable = variable;
        this.session = processor.getSession();
        this.initializeModifier(processor);
    }

    protected void initializeModifier(RequestProcessor processor) {
        try {
            processor.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    VariableModifier2.this.initialValue = VariableModifier2.this.getInitialValue(graph);
                    VariableModifier2.this.initializeValidator(graph, VariableModifier2.this.variable);
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((String)"Modifier initialization failed, see exception for details.", (Throwable)e);
            this.modifierFailed = e;
        }
    }

    protected void initializeValidator(ReadGraph graph, Variable var) throws DatabaseException {
        final Function1 validator = (Function1)this.variable.getPossiblePropertyValue(graph, "HasInputValidator");
        if (validator != null) {
            this.variableInputValidator = new InputValidator(){

                public String isValid(Object newValue) {
                    return (String)validator.apply((Object)((String)newValue));
                }
            };
        }
    }

    protected void doModify(String label) {
        this.session.asyncRequest((Write)new VariableWrite(this.variable, label), parameter -> {
            if (parameter != null) {
                ErrorLogger.defaultLogError((Throwable)parameter);
            } else {
                this.modifySuccessful();
            }
        });
    }

    protected void modifySuccessful() {
    }

    protected String getInitialValue(ReadGraph graph) throws DatabaseException {
        return (String)this.variable.getValue(graph, (Binding)Bindings.STRING);
    }

    public String getValue() {
        return this.initialValue;
    }

    public String isValid(String label) {
        if (this.modifierFailed != null) {
            return "Could not resolve validator for this value, modification denied. Reason: " + this.modifierFailed.getMessage();
        }
        if (this.variableInputValidator != null) {
            return this.variableInputValidator.isValid((Object)label);
        }
        return null;
    }

    public final void modify(String label) {
        if (this.modifierFailed != null) {
            throw new Error("modifier failed: " + this.modifierFailed.getMessage());
        }
        this.doModify(label);
    }
}

