/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.browsecontexts;

import java.util.Collection;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.ActionBrowseContextRequest;
import org.simantics.browsing.ui.model.browsecontexts.ContributedActionBrowseContexts;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;

public class ResolveActionBrowseContext
extends UnaryRead<NodeContext, ActionBrowseContext> {
    public ResolveActionBrowseContext(NodeContext parameter) {
        super((Object)parameter);
    }

    private Resource getPossibleResource(ReadGraph graph) throws DatabaseException {
        Object input = ((NodeContext)this.parameter).getConstant(BuiltinKeys.INPUT);
        if (input instanceof Resource) {
            return (Resource)input;
        }
        if (input instanceof Variable) {
            return ((Variable)input).getPossibleRepresents(graph);
        }
        return null;
    }

    private String getPossibleUIContext() {
        return (String)((NodeContext)this.parameter).getConstant(BuiltinKeys.UI_CONTEXT);
    }

    public ActionBrowseContext perform(ReadGraph graph) throws DatabaseException {
        Resource resource = this.getPossibleResource(graph);
        if (resource == null) {
            return null;
        }
        Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(resource));
        if (indexRoot == null) {
            return null;
        }
        Collection contexts = (Collection)graph.syncRequest((Read)new ContributedActionBrowseContexts(indexRoot, resource, this.getPossibleUIContext()));
        if (contexts.isEmpty()) {
            return null;
        }
        return (ActionBrowseContext)graph.syncRequest((Read)new ActionBrowseContextRequest(contexts));
    }
}

