/*******************************************************************************
 * Copyright (c) 2015 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.tests;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * A browse context {@link Test} implementation that always fails and is
 * compatible with all content types.
 * 
 * @author Tuukka Lehtonen
 */
public enum FailTest implements Test {
    INSTANCE;

    public static FailTest get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return true;
    }

    @Override
    public boolean test(ReadGraph graph, Object content) throws DatabaseException {
        return false;
    }

}
