/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.actions;

import java.util.Comparator;

public interface IActionCategory {
    String getLabel();
    double getPriority();
    boolean isSubmenu();
    
    public static final Comparator<IActionCategory> ACTION_CATEGORY_COMPARATOR = new Comparator<IActionCategory>() {
        @Override
        public int compare(IActionCategory o1, IActionCategory o2) {
            if(o1 == null) {
                if(o2 == null)
                    return 0;
                return -1;
            }
            if(o2 == null)
                return 1;
            double p1 = o1.getPriority();
            double p2 = o2.getPriority();
            if(p1 < p2)
                return -1;
            if(p1 > p2)
                return 1;
            String label1 = o1.getLabel();
            String label2 = o2.getLabel();
            if(label1 == null) {
                if(label2 == null)
                    return 0;
                else
                    return -1;
            }
            else {
                if(label2 == null)
                    return 1;
                else
                    return label1.compareTo(label2);
            } 
        }
    };
}
