/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl.contribution;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.graph.impl.request.ResourceQuery;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.utils.ui.ErrorLogger;

public abstract class FinalImageDecoratorContributionImpl
implements ImageDecorator {
    final ImageDecorator FRESH = new ImageDecorator.Stub();
    final ImageDecorator PENDING = new ImageDecorator.Stub();
    final ImageDecorator NO_DECORATION = new ImageDecorator.Stub();
    protected final PrimitiveQueryUpdater updater;
    private final ResourceQuery<ImageDecorator> imageQuery;
    private final BuiltinKeys.ImageDecoratorKey key;
    protected ImageDecorator decorator = this.FRESH;
    protected final NodeContext context;

    public Object getIdentity(BuiltinKeys.ImageDecoratorKey key) {
        return key;
    }

    private void request() {
        DataSource source = this.updater.getDataSource(AsyncReadGraph.class);
        assert (source != null);
        Procedure<ImageDecorator> procedure = this.createProcedure();
        source.schedule(graph -> {
            if (procedure instanceof Listener) {
                graph.asyncRequest(this.imageQuery, (Listener)procedure);
            } else {
                graph.asyncRequest(this.imageQuery, procedure);
            }
        });
    }

    public <Image> Image decorateImage(Image image, String column, int itemIndex) {
        if (this.FRESH == this.decorator) {
            this.decorator = this.PENDING;
            this.request();
        }
        return (Image)this.decorator.decorateImage(image, column, itemIndex);
    }

    public FinalImageDecoratorContributionImpl(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ImageDecoratorKey key) {
        this.updater = updater;
        this.context = context;
        this.key = key;
        this.imageQuery = new ResourceQuery<ImageDecorator>(this.getIdentity(key), context){

            public ImageDecorator perform(ReadGraph graph) throws DatabaseException {
                try {
                    return FinalImageDecoratorContributionImpl.this.getDecorator(graph, this.context);
                }
                catch (PendingVariableException pendingVariableException) {
                    return FinalImageDecoratorContributionImpl.this.PENDING;
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    ErrorLogger.defaultLogError((String)"FinalImageDecoratorContributionImpl.imageQuery produced unexpected exception.", (Throwable)t);
                    return null;
                }
            }

            public String toString() {
                return FinalImageDecoratorContributionImpl.this + " with context " + this.context;
            }
        };
    }

    protected Procedure<ImageDecorator> createProcedure() {
        return new Procedure<ImageDecorator>(){

            public void execute(ImageDecorator result) {
                FinalImageDecoratorContributionImpl.this.replaceResult(result);
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((String)"FinalImageDecoratorContributionImpl.imageQuery failed, see exception for details.", (Throwable)t);
            }
        };
    }

    protected void replaceResult(ImageDecorator result) {
        if (result == null) {
            result = this.NO_DECORATION;
        }
        this.decorator = result;
        this.updater.scheduleReplace(this.context, (NodeContext.PrimitiveQueryKey)this.key, (Object)this);
    }

    public abstract ImageDecorator getDecorator(ReadGraph var1, NodeContext var2) throws DatabaseException;
}

