/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contributor.viewpoint;

import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointContributionKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.ViewpointContribution;
import org.simantics.browsing.ui.content.ViewpointContributionFactory;
import org.simantics.browsing.ui.graph.impl.contribution.ViewpointContributionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.InvalidVariableException;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.utils.ReflectionUtils;

abstract public class ViewpointContributorImpl<T> implements Contributor<ViewpointContributionFactory> {

    abstract public Collection<?> getContribution(ReadGraph graph, T input) throws DatabaseException;

    abstract public String getViewpointId();

    final private Class<?> clazz;
    
    protected Layer0 L0;
    protected Layer0X L0X;

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    public ViewpointContributorImpl() {
        clazz = ReflectionUtils.getSingleParameterType(getClass());
    }

    public ViewpointContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public ViewpointContributionFactory getFactory() {

        return new ViewpointContributionFactory() {

            @Override
            public String getViewpointId() {
                return ViewpointContributorImpl.this.getViewpointId();
            }

            @Override
            public ViewpointContribution create(final PrimitiveQueryUpdater updater, NodeContext context, final ViewpointContributionKey key) {

                return new ViewpointContributionImpl(updater, context, key) {

                    @SuppressWarnings("unchecked")
                    @Override
                    public Collection<NodeContext> children(ReadGraph graph, NodeContext context) throws DatabaseException {

                        try {
                            T input = (T)context.getConstant(BuiltinKeys.INPUT);
                            L0 = Layer0.getInstance(graph);
                            L0X = Layer0X.getInstance(graph);
                            return NodeContextUtil.toContextCollectionWithInput(ViewpointContributorImpl.this, ViewpointContributorImpl.this.getContribution(graph, input));
                        } catch (InvalidVariableException e) {
                            return Collections.emptyList();
                        }

                    }

                    @Override
                    public Tester getNodeContextTester() {
                        return ViewpointContributorImpl.this.getNodeContextTester();
                    }

                    @Override
                    public Class<?> getInputClass() {
                        return ViewpointContributorImpl.this.getInputClass();
                    }

                };

            }

        };

    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

}
