/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contribution;

import java.util.Collection;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointContributionKey;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.utils.ui.ErrorLogger;

/**
 * Implement {@link #children(AsyncReadGraph)} and {@link #hasChildren(AsyncReadGraph)}.
 * 
 * @author Tuukka Lehtonen
 */
abstract public class ViewpointContributionImpl extends FinalViewpointContributionImpl {

    public ViewpointContributionImpl(PrimitiveQueryUpdater updater,
            NodeContext context, ViewpointContributionKey key) {
        super(updater, context, key);
    }

    @Override
    protected Procedure<Collection<NodeContext>> createProcedure() {

        return new Listener<Collection<NodeContext>>() {

            @Override
            public void execute(Collection<NodeContext> result) {
                replaceChildrenResult(result);
            }

            @Override
            public boolean isDisposed() {
                return updater.isDisposed();
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError("LazyContributionImpl.childQuery failed, see exception for details.", t);
            }

            @Override
            public String toString() {
                return "LazyContributionImpl[" + System.identityHashCode(ViewpointContributionImpl.this) + "].childProcedure";
            }

        };

    }


}
