/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;

/**
 * @author Tuukka Lehtonen
 */
public class ResourceProperty implements IProperty {

    protected final Type          type;

    protected final Resource      subject;
    protected final Resource      predicate;
    protected final Resource      value;
    protected final ResourceArray path;

    public ResourceProperty(Type type, Resource subject, Resource predicate, Resource value, ResourceArray path) {
        this.type = type;
        this.subject = subject;
        this.predicate = predicate;
        this.value = value;
        this.path = path;
    }

    @Override
    public Type getType() {
        return type;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getData(Class<T> clazz) {
        T t = (T) getAdapter(clazz);
        if (t != null)
            return t;
        throw new ClassCastException("class " + clazz.getCanonicalName() + " not adaptable from " + toString());
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[subject=" + subject + ", predicate=" + predicate + ", value=" + value
        + ", path=" + path + "]";
    }

    @SuppressWarnings({ "rawtypes", "unchecked" })
    @Override
    public Object getAdapter(Class adapter) {
        return adapt(adapter);
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T adapt(Class<T> adapter) {
        if (adapter == ResourceArray[].class)
            return (T) new ResourceArray[] { new ResourceArray(subject, predicate, value), path };
        if (adapter == ResourceArray.class)
            return (T) new ResourceArray(subject, predicate, value);
        if (adapter == Resource[].class)
            return (T) new Resource[] { subject, predicate, value };
        if (adapter == Resource.class)
            // Return the object of the specified statement
            return (T) value;
        return null;
    }

    @Override
    public int propertyHashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + subject.hashCode();
        result = prime * result + predicate.hashCode();
        result = prime * result + path.hashCode();
        return result;
    }

    @Override
    public boolean propertyEquals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ResourceProperty other = (ResourceProperty) obj;
        return subject.equals(other.subject) && predicate.equals(other.predicate) && path.equals(other.path);
    }

    @Override
    public int hashCode() {
        return propertyHashCode() * 31 + value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!propertyEquals(obj))
            return false;
        ResourceProperty other = (ResourceProperty) obj;
        return value.equals(other.value) && type.equals(other.type);

    }

}
