/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.function.Consumer;

import org.simantics.browsing.ui.DataSource;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.ui.ErrorLogger;

public class ReadGraphDataSource implements DataSource<ReadGraph> {

    final private AsyncRequestProcessor processor;
    final private LifecycleSupport ls;

    public ReadGraphDataSource(AsyncRequestProcessor processor) {
        this.processor = processor;
        this.ls = processor.getService(LifecycleSupport.class);
    }

    @Override
    public void schedule(final Consumer<ReadGraph> callback) {
        if(ls.isClosing() || ls.isClosed()) return;
        processor.asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph graph) {
                if(ls.isClosing() || ls.isClosed()) return;
                callback.accept(graph);
            }
        }, new ProcedureAdapter<Object>() {
            @Override
            public void exception(Throwable t) {
                ErrorLogger.defaultLogError(t);
            }
        });
    }

    @Override
    public Class<ReadGraph> getProvidedClass() {
        return ReadGraph.class;
    }

}
