/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.common.processors.AbstractPrimitiveQueryProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.Container;

public abstract class LazyGraphQueryProcessor<Result> extends AbstractPrimitiveQueryProcessor<Container<Result>> {

    /**
     * Returns the value to be returned as the initial query result, before the
     * real result has been calculated.
     * 
     * @return the initial result value stored in the returned {@link Container}
     */
    protected abstract Result initial();

    /**
     * 
     * @param graph
     * @param context
     * @return
     */
    protected abstract Result compute(ReadGraph graph, NodeContext context, PrimitiveQueryKey<Container<Result>> key) throws DatabaseException;

    final Result init = initial();

    @Override
    public Container<Result> query(PrimitiveQueryUpdater updater, NodeContext context,
            final PrimitiveQueryKey<Container<Result>> key) {
        assert(updater != null);
        assert(context != null);
        assert(key != null);

        return new LazyResourceQueryContainer<Result>(updater, context, init) {
            @Override
            protected PrimitiveQueryKey<Container<Result>> getKey() {
                return key;
            }

            @Override
            protected Result compute(ReadGraph graph) throws DatabaseException {
                return LazyGraphQueryProcessor.this.compute(graph, context, key);
            }
        };
    }

    @Override
    public String toString() {
        return "abstract LazyGraphQueryProcessor2";
    }

}
