/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.db.Resource;
import org.simantics.db.management.ISessionContext;

/**
 * @author Antti Villberg
 */
public class GraphInputSources {

    public static SessionContextInputSource uriSource(String uri) {
        return new URIResourceInputSource(uri);
    }

    public static SessionContextInputSource projectSource() {
        return new SessionContextInputSource() {
            @Override
            public Object get(ISessionContext ctx) {
                Resource project = Simantics.peekProjectResource();
                return project != null ? project : GraphExplorer.EMPTY_INPUT;
            }
            @Override
            public IWorkbenchPart getProvider() {
            	return null;
            }
        };
    }

    public static SessionContextInputSource constant(final Object input) {
        if (input == null)
            throw new NullPointerException("null input");
        return new SessionContextInputSource() {
            @Override
            public Object get(ISessionContext ctx) {
                return input;
            }
            @Override
            public IWorkbenchPart getProvider() {
            	return null;
            }
        };
    }

    public static SessionContextInputSource workbenchSelection() {
        return new WorkbenchSelectionInputSource();
    }

}
