package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.BuiltinKeys.LabelDecoratorKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.graph.impl.contribution.LabelDecoratorContributionImpl;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class EvaluatorLabelDecorator extends LabelDecoratorContributionImpl {

	final BrowseContext browseContext;
	final boolean useNodeBrowseContexts;
	
    public EvaluatorLabelDecorator(PrimitiveQueryUpdater updater, NodeContext context, LabelDecoratorKey key,
    		BrowseContext browseContext, boolean useNodeBrowseContexts) {
		super(updater, context, key);
		this.browseContext = browseContext;
		this.useNodeBrowseContexts = useNodeBrowseContexts;
	}

    @Override
    public LabelDecorator getDecorator(ReadGraph graph, NodeContext context)
    throws DatabaseException {
        return BrowseContext.get(graph,context,browseContext,useNodeBrowseContexts).getLabelDecorator(graph, context);
    }
    
}
