/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class ConsistsOfViewpointFactory implements ViewpointFactory {

    @Override
    public Viewpoint create(PrimitiveQueryUpdater updater, final NodeContext context, ViewpointKey key) {
        assert(updater != null);
        assert(context != null);

        return new LazyViewpoint(updater, context, key) {
            @Override
            public NodeContext[] children(ReadGraph graph) throws DatabaseException {
            	Layer0 L0 = Layer0.getInstance(graph);
                return toContextsWithInput(graph.getObjects((Resource) context.getConstant(BuiltinKeys.INPUT), L0.ConsistsOf));
            }

            @Override
            public Boolean hasChildren(ReadGraph graph) throws DatabaseException {
                return Boolean.valueOf(children(graph).length > 0);
            }
        };
    }

    @Override
    public String toString() {
        return "Structure";
    }

}
