/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.viewpoints;

import java.util.Collection;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.content.Viewpoint;

public abstract class ViewpointStub
implements Viewpoint {
    protected NodeContext[] children = Viewpoint.PENDING_CHILDREN;
    protected Boolean hasChildren = Viewpoint.PENDING_HAS_CHILDREN;

    public final void setChildren(PrimitiveQueryUpdater updater, NodeContext[] children) {
        NodeContext c;
        if (children == null) {
            throw new NullPointerException(this + ": null children produced by " + this.getClass().getName());
        }
        NodeContext[] nodeContextArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            c = nodeContextArray[n2];
            updater.incRef(c);
            ++n2;
        }
        nodeContextArray = this.children;
        n = this.children.length;
        n2 = 0;
        while (n2 < n) {
            c = nodeContextArray[n2];
            updater.decRef(c);
            ++n2;
        }
        this.children = children;
    }

    public void setHasChildren(Boolean hasChildren) {
        if (this.children == null) {
            throw new NullPointerException(this + ": null hasChildren produced by " + this.getClass().getName());
        }
        this.hasChildren = hasChildren;
    }

    public NodeContext[] toContextsWithInput(Object ... children) {
        return NodeContextUtil.toContextsWithInput(children);
    }

    public NodeContext[] toContextsWithInput(Collection<?> children) {
        return NodeContextUtil.toContextsWithInput(children);
    }

    public NodeContext[] toContexts(Collection<?> children, NodeContextUtil.NodeContextFactory factory) {
        return NodeContextUtil.toContexts(children, factory);
    }

    protected <T> T getInput(NodeContext context) {
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o == null) {
            throw new NullPointerException("null input");
        }
        return (T)o;
    }

    protected <T> T tryGetInput(NodeContext context, Class<T> clazz) {
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o != null && clazz.isInstance(o)) {
            return (T)o;
        }
        return null;
    }
}

