/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.SelectionRequest;
import org.simantics.browsing.ui.common.processors.AbstractPrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.processors.ProcessorLifecycle;
import org.simantics.browsing.ui.common.views.DefaultFilterStrategy;
import org.simantics.browsing.ui.common.views.IFilterStrategy;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.utils.datastructures.Pair;

public class FilterSelectionRequestQueryProcessor
extends AbstractPrimitiveQueryProcessor<Collection<SelectionRequest>>
implements ProcessorLifecycle {
    HashMap<NodeContext, String> filters = new HashMap();
    HashMap<NodeContext, Pair<NodeContext.PrimitiveQueryKey<?>, PrimitiveQueryUpdater>> updaters = new HashMap();
    IFilterStrategy filterStrategy;

    public FilterSelectionRequestQueryProcessor() {
        this(new DefaultFilterStrategy());
    }

    public FilterSelectionRequestQueryProcessor(IFilterStrategy filterStrategy) {
        Assert.isNotNull((Object)filterStrategy, (String)"null filter strategy not allowed");
        this.filterStrategy = filterStrategy;
    }

    public IFilterStrategy getFilterStrategy() {
        return this.filterStrategy;
    }

    public void setFilterStrategy(IFilterStrategy filterStrategy) {
        this.filterStrategy = filterStrategy;
    }

    @Override
    public String toString() {
        return "SelectionRequestProcessor";
    }

    public Object getIdentifier() {
        return BuiltinKeys.SELECTION_REQUESTS;
    }

    public Collection<SelectionRequest> query(PrimitiveQueryUpdater updater, NodeContext context, NodeContext.PrimitiveQueryKey<Collection<SelectionRequest>> key) {
        this.updaters.put(context, new Pair(key, (Object)updater));
        return this.makeFilterRequest(updater, context, this.filters.get(context));
    }

    private String adjustFilter(String filter) {
        String[] tokens = filter.split(" ");
        StringBuilder b = new StringBuilder();
        boolean first = true;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!token.startsWith("$")) {
                if (first) {
                    first = false;
                } else {
                    b.append(" ");
                }
                b.append(token);
            }
            ++n2;
        }
        String result = b.toString();
        if (result.isEmpty()) {
            return "*";
        }
        return result;
    }

    private Collection<SelectionRequest> makeFilterRequest(PrimitiveQueryUpdater updater, NodeContext context, final String filter_) {
        if (filter_ == null || filter_.isEmpty()) {
            return null;
        }
        String filter = this.adjustFilter(filter_);
        String regExFilter = this.filterStrategy.toPatternString(filter);
        if (regExFilter == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(regExFilter);
        final Matcher matcher = pattern.matcher("");
        return Collections.singletonList(new SelectionRequest(){

            public SelectionRequest.Request getRequest() {
                return SelectionRequest.Request.FILTER;
            }

            public boolean isIncluded(NodeQueryManager manager, Object object) {
                NodeContext context = (NodeContext)object;
                Labeler labeler = (Labeler)manager.query(context, BuiltinKeys.SELECTED_LABELER);
                if (labeler == null) {
                    return false;
                }
                Map labels = labeler.getLabels();
                if (labels.isEmpty()) {
                    return false;
                }
                for (String s : labels.values()) {
                    if (s == null) continue;
                    matcher.reset(s.toLowerCase());
                    if (!matcher.matches()) continue;
                    return false;
                }
                return true;
            }

            public <T> T getData() {
                return (T)filter_;
            }
        });
    }

    public String getFilter(NodeContext context) {
        return this.filters.get(context);
    }

    public void setFilter(NodeContext context, String filter) {
        if (filter == null) {
            this.filters.remove(context);
        } else {
            this.filters.put(context, filter);
        }
        Pair<NodeContext.PrimitiveQueryKey<?>, PrimitiveQueryUpdater> p = this.updaters.get(context);
        if (p == null) {
            return;
        }
        if (p.second == null) {
            throw new IllegalArgumentException("context not found in cache");
        }
        ((PrimitiveQueryUpdater)p.second).scheduleReplace(context, (NodeContext.PrimitiveQueryKey)p.first, this.makeFilterRequest((PrimitiveQueryUpdater)p.second, context, filter));
    }

    @Override
    public void attached(GraphExplorer explorer) {
    }

    @Override
    public void detached(GraphExplorer explorer) {
    }

    @Override
    public void clear() {
        this.filters.clear();
        this.updaters.clear();
    }
}

