/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.internal;

import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Set;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.internal.UIElementReference;

public interface IGECache {
    public <T> IGECacheEntry getEntry(NodeContext var1, NodeContext.CacheKey<T> var2);

    public <T> IGECacheEntry put(NodeContext var1, NodeContext.CacheKey<T> var2, T var3);

    public <T> void putTreeReference(NodeContext var1, NodeContext.CacheKey<T> var2, UIElementReference var3);

    public <T> T get(NodeContext var1, NodeContext.CacheKey<T> var2);

    public <T> Set<UIElementReference> getTreeReference(NodeContext var1, NodeContext.CacheKey<T> var2);

    public <T> void remove(NodeContext var1, NodeContext.CacheKey<T> var2);

    public <T> Set<UIElementReference> removeTreeReference(NodeContext var1, NodeContext.CacheKey<T> var2);

    public boolean isShown(NodeContext var1);

    public void incRef(NodeContext var1);

    public void decRef(NodeContext var1);

    public void dispose();

    public static class GECacheEntry
    implements IGECacheEntry {
        private Object result;
        private final NodeContext context;
        private final NodeContext.CacheKey<?> key;
        private Set<IGECacheEntry> callers = new THashSet(2);

        public <T> GECacheEntry(NodeContext context, NodeContext.CacheKey<T> key, T result) {
            this.context = context;
            this.key = key;
            this.result = result;
        }

        @Override
        public Collection<IGECacheEntry> getDependencies() {
            return this.callers;
        }

        @Override
        public Object getValue() {
            return this.result;
        }

        @Override
        public void addDependency(IGECacheEntry caller) {
            assert (caller != null);
            this.callers.add(caller);
        }

        @Override
        public void setValue(Object value) {
            this.result = value;
        }

        @Override
        public NodeContext getContext() {
            return this.context;
        }

        @Override
        public NodeContext.CacheKey<?> getKey() {
            return this.key;
        }

        @Override
        public void reset() {
            this.callers = new THashSet(2);
        }

        public int hashCode() {
            return 31 * this.context.hashCode() | this.key.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            GECacheEntry i = (GECacheEntry)object;
            return this.key.equals(i.key) && this.context.equals(i.context);
        }
    }

    public static interface IGECacheEntry {
        public Object getValue();

        public void setValue(Object var1);

        public NodeContext getContext();

        public NodeContext.CacheKey<?> getKey();

        public Collection<IGECacheEntry> getDependencies();

        public void addDependency(IGECacheEntry var1);

        public void reset();
    }
}

