/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.node;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.ConstantKey;
import org.simantics.browsing.ui.common.NodeContextBuilder;

public class StandardNodes {

    public static final ConstantKey<Object> CONTEXT = new ConstantKey<Object>() {
        @Override
        public String toString() {
            return "Context";
        }
    };

    public static final ConstantKey<Object> CONTEXT2 = new ConstantKey<Object>() {
        @Override
        public String toString() {
            return "Context2";
        }
    };

    public static final ConstantKey<Object> FUNCTION = new ConstantKey<Object>() {
        @Override
        public String toString() {
            return "Function";
        }
    };

    private static ConstantKey<?>[] KEYS3 = { BuiltinKeys.INPUT, CONTEXT, FUNCTION };
    private static ConstantKey<?>[] KEYS4 = { BuiltinKeys.INPUT, CONTEXT, CONTEXT2, FUNCTION };

    public static <Input, Context, Function> NodeContext build(Input input, Context context, Function function) {
        return NodeContextBuilder.buildWithData(KEYS3, new Object[] { input, context, function });
    }

    public static <Input, Context, Context2, Function> NodeContext build(Input input, Context context, Context2 context2, Function function) {
        return NodeContextBuilder.buildWithData(KEYS4, new Object[] { input, context, context2, function });
    }

}
