/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.labelers;

import java.util.Map;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.utils.datastructures.ArrayMap;

/**
 * @author Tuukka Lehtonen
 */
public class ConstantLabelerFactory implements LabelerFactory {

    private final LabelerStub stub;

    public ConstantLabelerFactory(int category, Map<String, String> labels) {
        stub = new LabelerStub();
        stub.setContent(new LabelerContent(category, labels));
    }

    public ConstantLabelerFactory(int category, String ... keyValuePairs) {
        assert((keyValuePairs.length & 1) == 0);
        stub = new LabelerStub();
        String[] keys = new String[keyValuePairs.length / 2];
        String[] values = new String[keyValuePairs.length / 2];
        for(int i=0;i<keyValuePairs.length/2;i++) {
            keys[i] = keyValuePairs[2*i];
            values[i] = keyValuePairs[2*i+1];
        }
        stub.setContent(new LabelerContent(category, new ArrayMap<String, String>(keys, values)));
    }

    @Override
    public Labeler create(PrimitiveQueryUpdater manager, NodeContext context, LabelerKey key) {
        return stub;
    }

}
