/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.internal;

import java.util.Deque;
import java.util.List;

import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.utils.datastructures.disposable.IDisposable;

/**
 * An internal interface for supporting the implementation of
 * {@link GraphExplorer}. Contains methods for the interaction of GraphExplorer
 * and {@link GENodeQueryManager}, and {@link UpdateRunner}.
 * 
 * <p>
 * The main purpose of this context class is to support switching of explorer
 * inputs in a proper way which disposes all the {@link GENodeQueryManager}'s
 * and any resource queries possibly hidden behind them.
 * </p>
 * 
 * @author Tuukka Lehtonen
 */
public interface IGraphExplorerContext extends IDisposable {

    int queryIndent();
    int queryIndent(int offset);

    IGECache getCache();

    <T> NodeQueryProcessor<T> getProcessor(Object o);
    <T> PrimitiveQueryProcessor<T> getPrimitiveProcessor(Object o);
    <T> DataSource<T> getDataSource(Class<T> clazz);

    void update(UIElementReference ref);

    Object getPropagateLock();
    Object getPropagateListLock();

    void setPropagating(boolean b);
    boolean isPropagating();

    void setScheduleList(List<Runnable> list);
    List<Runnable> getScheduleList();

    Deque<Integer> getActivity();
    void setActivityInt(int i);
    int getActivityInt();

    void scheduleQueryUpdate(Runnable r);

}
