/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common;

/**
 * A generic wrapper that associates a double-based preference indicator value
 * for any object. This class can be used make objects comparable.
 * 
 * @author Tuukka Lehtonen
 * 
 * @param <T> the type of the object to be made comparable
 */
public class Preference<T> implements Comparable<Preference<T>> {
    public final T      object;
    public final double preference;

    public Preference(T object, double preference) {
        this.object = object;
        this.preference = preference;
    }

    @Override
    public int compareTo(Preference<T> other) {
        if (preference == other.preference)
            return 0;
        return (preference > other.preference) ? -1 : 1;
    }
    
    @Override
    public String toString() {
    	return object + " with preference " + preference;
    }
    
}