/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.application.arguments;

import java.util.ListIterator;
import org.simantics.application.arguments.IArgument;
import org.simantics.application.arguments.IArgumentValidator;

public interface IArgumentFactory<T> {
    public String getArgument();

    public IArgument<T> parse(String var1, ListIterator<String> var2);

    public static abstract class Argument<T>
    implements IArgument<T> {
        String key;

        public Argument(String key) {
            assert (key != null);
            this.key = key;
        }

        @Override
        public String getArgument() {
            return this.key;
        }

        @Override
        public abstract T getValue();

        public String toString() {
            return "(" + this.getValue().getClass().getSimpleName() + ") " + this.getValue().toString();
        }
    }

    public static abstract class ArgumentFactory<V>
    implements IArgumentFactory<V> {
        String arg;
        protected IArgumentValidator<V> validator;

        public ArgumentFactory(String arg) {
            this(arg, null);
        }

        public ArgumentFactory(String arg, IArgumentValidator<V> validator) {
            this.arg = arg;
            this.validator = validator;
        }

        @Override
        public String getArgument() {
            return this.arg;
        }

        protected IArgumentValidator<V> getValidator() {
            return this.validator;
        }
    }

    public static class BooleanArgument
    extends Argument<Boolean> {
        Boolean value;

        public BooleanArgument(String key, Boolean value) {
            super(key);
            this.value = value;
        }

        @Override
        public Boolean getValue() {
            return this.value;
        }
    }

    public static class IntegerArgument
    extends Argument<Integer> {
        Integer value;

        public IntegerArgument(String key, Integer value) {
            super(key);
            this.value = value;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }
    }

    public static class IntegerArgumentFactory
    extends ArgumentFactory<Integer> {
        private Integer lowLimit;
        private Integer highLimit;

        public IntegerArgumentFactory(String key) {
            this(key, null, null);
        }

        public IntegerArgumentFactory(String key, Integer lowLimit, Integer highLimit) {
            super(key);
            this.lowLimit = lowLimit;
            this.highLimit = highLimit;
        }

        @Override
        public IArgument<Integer> parse(String key, ListIterator<String> tail) {
            if (this.getArgument().equalsIgnoreCase(key) && tail.hasNext()) {
                try {
                    Integer l = Integer.valueOf(tail.next());
                    if (this.lowLimit != null && this.lowLimit > l) {
                        throw new IllegalArgumentException("value is less than low limit, " + l + " < " + this.lowLimit);
                    }
                    if (this.highLimit != null && this.highLimit < l) {
                        throw new IllegalArgumentException("value is greater than high limit, " + l + " > " + this.highLimit);
                    }
                    return new IntegerArgument(this.getArgument(), l);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return null;
        }
    }

    public static class LongArgument
    extends Argument<Long> {
        Long value;

        public LongArgument(String key, Long value) {
            super(key);
            this.value = value;
        }

        @Override
        public Long getValue() {
            return this.value;
        }
    }

    public static class LongArgumentFactory
    extends ArgumentFactory<Long> {
        public LongArgumentFactory(String key) {
            super(key);
        }

        @Override
        public IArgument<Long> parse(String key, ListIterator<String> tail) {
            if (this.getArgument().equalsIgnoreCase(key) && tail.hasNext()) {
                try {
                    Long l = Long.valueOf(tail.next());
                    return new LongArgument(this.getArgument(), l);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return null;
        }
    }

    public static class NoValueArgumentFactory
    extends ArgumentFactory<Boolean> {
        public NoValueArgumentFactory(String key) {
            super(key);
        }

        @Override
        public IArgument<Boolean> parse(String key, ListIterator<String> tail) {
            if (this.getArgument().equalsIgnoreCase(key)) {
                return new BooleanArgument(this.getArgument(), Boolean.TRUE);
            }
            return null;
        }
    }

    public static class StringArgument
    extends Argument<String> {
        String value;

        public StringArgument(String key, String value) {
            super(key);
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static class StringArgumentFactory
    extends ArgumentFactory<String> {
        public StringArgumentFactory(String key) {
            super(key);
        }

        public StringArgumentFactory(String key, IArgumentValidator<String> validator) {
            super(key, validator);
        }

        @Override
        public IArgument<String> parse(String key, ListIterator<String> tail) {
            if (this.getArgument().equalsIgnoreCase(key) && tail.hasNext()) {
                String valid;
                String next = tail.next();
                IArgumentValidator validator = this.getValidator();
                if (validator != null && (valid = validator.isValid(next)) != null) {
                    tail.previous();
                    throw new IllegalArgumentException(valid);
                }
                return new StringArgument(this.getArgument(), next);
            }
            return null;
        }
    }
}

