/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.application.db;

import java.io.IOException;

import org.simantics.application.arguments.Arguments;
import org.simantics.application.arguments.IArguments;
import org.simantics.application.arguments.SimanticsArguments;
import org.simantics.db.ServerI;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;
import org.simantics.utils.datastructures.disposable.IDisposable;

public class DatabaseHandle extends AbstractDisposable implements IDatabaseHandle, IDisposable {

    private ServerI       server;

    private Session       session;

    @SuppressWarnings("unused")
    private final boolean deleteAtDispose;

    /**
     * @param arguments
     * @return
     * @throws Exception
     */
    public static DatabaseHandle open(String[] arguments) throws Exception {
        IArguments args = Arguments.parse(arguments, SimanticsArguments.SERVER);
        if (!args.contains(SimanticsArguments.SERVER))
            throw new IllegalArgumentException("Missing " + SimanticsArguments.SERVER.getArgument() + " argument, a server is required.");

        DatabaseHandle handle = new DatabaseHandle();
        handle.init(args.get(SimanticsArguments.SERVER), false);
        return handle;
    }

    /**
     * @param arguments
     * @return
     * @throws Exception
     */
    public static DatabaseHandle open(String serverAddress) throws Exception {
        return new DatabaseHandle().init(serverAddress, false);
    }

//    /**
//     * @param arguments
//     * @return
//     * @throws Exception
//     */
//    public static DatabaseHandle open(ServerAddress address) throws Exception {
//        return DatabaseHandle.open(address.getDbid());
//    }

    /**
     * @param arguments
     * @return
     * @throws Exception
     */
    public static DatabaseHandle checkout(String serverAddress) throws Exception {
        return new DatabaseHandle().init(serverAddress, true);
    }

//    /**
//     * @param arguments
//     * @return
//     * @throws Exception
//     */
//    public static DatabaseHandle checkout(ServerAddress address) throws Exception {
//        return new DatabaseHandle().init(address.getDbid(), true);
//    }

    private DatabaseHandle() {
        deleteAtDispose = false;
    }

    /**
     * @param arguments
     * @param deleteAtDispose
     * @throws Exception
     */
    public DatabaseHandle(String[] arguments, boolean deleteAtDispose) throws Exception {
        this.deleteAtDispose = deleteAtDispose;

        IArguments args = Arguments.parse(arguments,
                SimanticsArguments.SERVER,
                SimanticsArguments.CHECKOUT);

        if (!args.contains(SimanticsArguments.SERVER))
            throw new IllegalArgumentException("Missing " + SimanticsArguments.SERVER.getArgument() + " argument, a server is required.");
        boolean checkout = args.contains(SimanticsArguments.CHECKOUT);

        init(args.get(SimanticsArguments.SERVER), checkout);
    }

    /**
     * @param checkout
     * @return this
     * @throws Exception
     * @throws IOException
     */
    private DatabaseHandle init(String serverAddress, boolean checkout) throws IOException, Exception {
        if (checkout) {
            // Let UndoCoreManager pick a port on localhost for the working
            // copy by setting the address of the local ServerInfo to null.
            throw new UnsupportedOperationException("re-implement checkout");
//            activation = UndoCoreManager.getManager().checkout(
//                    new ServerInfo("Remote Server", server),
//                    new ServerInfo(UUID.randomUUID().toString()));
//
//            ServerAddress localServer = activation.getDescriptor().getLocal().getAddress();
//            session = DatabaseUtils.connect(localServer);
        } else {
            session = DatabaseUtils.connect(serverAddress);
//            session = DatabaseUtils.connect(new ServerAddress("", 0, serverAddress));
        }

        return this;
    }

    @Override
    protected void doDispose() {
        // TODO: make this robust and safe

        if (session != null) {
            try {
                LifecycleSupport support = session.getService(LifecycleSupport.class);
                support.close(-1, false);
                session = null;
            } catch (DatabaseException e) {
            }
        }

//        if (activation != null) {
//            try {
//                UndoCoreManager manager = UndoCoreManager.getManager();
//                manager.deactivate(activation, 3000, TimeUnit.MILLISECONDS);
//
//                if (deleteAtDispose) {
//                    IServerDescriptor desc = activation.getDescriptor();
//                    manager.deleteLocal(new ServerInfo[] { desc.getParent(), desc.getLocal() });
//                }
//            } catch (IOException e) {
//            } catch (InterruptedException e) {
//            }
//            activation = null;
//        }
    }

    /* (non-Javadoc)
     * @see org.simantics.application.db.IDatabaseHandle#getServer()
     */
    @Override
    public ServerI getServer() {
        return server;
    }

    /* (non-Javadoc)
     * @see org.simantics.application.db.IDatabaseHandle#getSession()
     */
    @Override
    public Session getSession() {
        return session;
    }

}
