/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.simantics.acorn.AcornDatabaseManager;
import org.simantics.acorn.AcornManagement;
import org.simantics.acorn.AcornSessionManagerImpl;
import org.simantics.db.Database;
import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.Driver;
import org.simantics.db.ServerI;
import org.simantics.db.ServerReference;
import org.simantics.db.Session;
import org.simantics.db.SessionReference;
import org.simantics.db.exception.DatabaseException;

public class AcornDriver
implements Driver {
    public static final String AcornDriverName = "acorn";
    private Map<String, ServerI> servers = new HashMap<String, ServerI>();
    private Map<String, Driver.Management> managements = new HashMap<String, Driver.Management>();

    public String getName() {
        return AcornDriverName;
    }

    public DatabaseUserAgent getDatabaseUserAgent(String address) throws DatabaseException {
        return AcornDatabaseManager.getDatabase(Paths.get(address, new String[0])).getUserAgent();
    }

    public void setDatabaseUserAgent(String address, DatabaseUserAgent dbUserAgent) throws DatabaseException {
        AcornDatabaseManager.getDatabase(Paths.get(address, new String[0])).setUserAgent(dbUserAgent);
    }

    public Session getSession(String address, Properties properties) throws DatabaseException {
        final Path dbFolder = Paths.get(address, new String[0]);
        Session session = AcornSessionManagerImpl.getInstance().createSession(new SessionReference(){

            public ServerReference getServerReference() {
                return new ServerReference(){

                    public Path getDBFolder() {
                        return dbFolder;
                    }
                };
            }

            public long getSessionId() {
                return 0L;
            }
        }, null);
        if (!properties.containsKey("clientId")) {
            properties.put("clientId", dbFolder.toAbsolutePath().toString());
        }
        session.registerService(Properties.class, (Object)properties);
        Session s = (Session)session.peekService(Session.class);
        if (s == null) {
            session.registerService(Session.class, (Object)session);
        }
        return session;
    }

    public ServerI getServer(String address, Properties properties) throws DatabaseException {
        ServerI server = this.servers.get(address);
        if (server == null) {
            server = new AcornServerI(AcornDatabaseManager.getDatabase(Paths.get(address, new String[0])), address);
            this.servers.put(address, server);
        }
        return server;
    }

    public Driver.Management getManagement(String address, Properties properties) throws DatabaseException {
        Driver.Management mgmt = this.managements.get(address);
        if (mgmt == null) {
            mgmt = new AcornManagement(AcornDatabaseManager.getDatabase(Paths.get(address, new String[0])), properties);
            this.managements.put(address, mgmt);
        }
        return mgmt;
    }

    private static class AcornServerI
    implements ServerI {
        private Database database;
        private String address;

        public AcornServerI(Database db, String address) {
            this.database = db;
            this.address = address;
        }

        public void stop() throws DatabaseException {
            this.database.tryToStop();
        }

        public void start() throws DatabaseException {
            this.database.start();
        }

        public boolean isActive() throws DatabaseException {
            return this.database.isRunning();
        }

        public String getAddress() throws DatabaseException {
            return this.address;
        }

        public String executeAndDisconnect(String command) throws DatabaseException {
            return "";
        }

        public String execute(String command) throws DatabaseException {
            return "";
        }
    }
}

