/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.grpc;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.EventHandler;
import org.simantics.district.network.grpc.Activator;
import org.simantics.district.network.grpc.Event;
import org.simantics.district.network.grpc.EventImpl;
import org.simantics.district.network.grpc.impl.PropertiesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public class EventBrokerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBrokerImpl.class);
    private static final String TOPIC_FEATURES = "TOPIC_FEATURES/";
    private static final String TOPIC_FEATURES_CHANGED = "TOPIC_FEATURES/CHANGED/";
    private static final String TOPIC_FEATURES_CHANGED_WILD = "TOPIC_FEATURES/CHANGED/*";
    private static final String TOPIC_FEATURES_CHANGES_REQUESTED = "TOPIC_FEATURES/CHANGES_REQUEST";
    private static final String TOPIC_FEATURES_CANCEL_CHANGES_REQUESTED = "TOPIC_FEATURES/CANCEL/CHANGES_REQUEST";
    IEventBroker broker;

    public EventBrokerImpl() {
        IEclipseContext eclipseContext = Activator.getServiceContext();
        this.broker = (IEventBroker)eclipseContext.get(IEventBroker.class);
    }

    public Flux<Event> subscribe(String requestId, String diagramURI, String topic) {
        LOGGER.info("Creating Event Flux for requestId {} with topic {}", (Object)requestId, (Object)topic);
        return Flux.create(sink -> {
            EventHandler handler = event -> {
                String innerTopic = event.getTopic();
                String featureId = innerTopic.substring(TOPIC_FEATURES_CHANGED.length());
                String[] propertyNames = event.getPropertyNames();
                Map requestOptions = (Map)event.getProperty("org.eclipse.e4.data");
                LOGGER.debug("Received event for requestId {} with topic {} with featureId {} and propertyNames {}", new Object[]{requestId, topic, featureId, propertyNames});
                PropertiesImpl properties = new PropertiesImpl();
                for (Map.Entry entry : requestOptions.entrySet()) {
                    properties.put((String)entry.getKey(), entry.getValue());
                }
                sink.next((Object)new EventImpl(innerTopic, featureId, properties));
            };
            Disposable d = () -> {
                boolean success = this.broker.unsubscribe(handler);
                LOGGER.info("Unsubscribed from topic {} sucessfully: {}", (Object)topic, (Object)success);
                this.unrequestChanges(requestId, diagramURI);
            };
            sink.onDispose(d);
            boolean success = this.broker.subscribe(topic, handler);
            LOGGER.info("Subscribed to topic {} sucessfully: {}", (Object)topic, (Object)success);
        });
    }

    public void unrequestChanges(String requestId, String diagramURI) {
        HashMap<String, String> requestOptions = new HashMap<String, String>();
        requestOptions.put("requestId", requestId);
        requestOptions.put("diagramURI", diagramURI);
        boolean success = this.broker.post("TOPIC_FEATURES/CANCEL/CHANGES_REQUEST/" + requestId, requestOptions);
        LOGGER.info("Canceled feature changes with id {} successfully: {}, with options {}", new Object[]{requestId, success, requestOptions});
    }

    public void requestChanges(String requestId, String diagramURI) {
        HashMap<String, String> requestOptions = new HashMap<String, String>();
        requestOptions.put("requestId", requestId);
        requestOptions.put("diagramURI", diagramURI);
        boolean success = this.broker.post("TOPIC_FEATURES/CHANGES_REQUEST/" + requestId, requestOptions);
        LOGGER.info("Requested feature changes with id {} successfully: {}, with options {}", new Object[]{requestId, success, requestOptions});
    }

    public Flux<Event> featureChanges(String requestId, String diagramURI) {
        return this.subscribe(requestId, diagramURI, TOPIC_FEATURES_CHANGED_WILD);
    }
}

