/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.grpc;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.district.network.grpc.DistrictGrpcServer;
import org.simantics.district.network.grpc.GrpcWebProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private static CompletableFuture<Void> start;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        Activator.startServers().exceptionally(thrw -> {
            LOGGER.error("Could not start District GRPC server / proxy", thrw);
            return null;
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (!start.isCancelled() && !start.isCompletedExceptionally()) {
            GrpcWebProxy.stop();
            DistrictGrpcServer.stopServer();
        }
        context = null;
    }

    public static synchronized CompletableFuture<Void> startServers() {
        if (start == null) {
            CompletableFuture<Void> grpcServer = DistrictGrpcServer.startServer();
            CompletableFuture<Void> grpcWebProxy = GrpcWebProxy.start();
            start = CompletableFuture.allOf(grpcServer, grpcWebProxy);
        }
        return start;
    }

    public static IEclipseContext getServiceContext() {
        return EclipseContextFactory.getServiceContext((BundleContext)Activator.getContext());
    }

    public static Path getPluginMetadataPath() {
        return Platform.getStateLocation((Bundle)context.getBundle()).toFile().toPath();
    }

    public static Path getGrpcwebproxyexe() throws IOException, URISyntaxException {
        return Activator.getEntry("/grpcwebproxy.exe");
    }

    private static Path getEntry(String path) throws IOException, URISyntaxException {
        URL entryURL = context.getBundle().getEntry(path);
        URL entryFileURL = FileLocator.toFileURL((URL)entryURL);
        URI encodedUri = new URI(entryFileURL.getProtocol(), entryFileURL.getPath(), null).normalize();
        return Paths.get(encodedUri);
    }
}

