/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.preferences;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;
import org.simantics.utils.ObjectUtils;

/**
 * A JFace property tester extension for the Eclipse command framework for
 * testing Eclipse preference values according to the specified arguments.
 * 
 * <p>
 * The tester first tries to find the specified property from the instance scope
 * (see {@link InstanceScope}) and if no value is found, it falls back to using
 * the default scope (see {@link DefaultScope})
 * 
 * <p>
 * The tester expects to receive:
 * <ul>
 * <li><b>args</b>: two strings separated by comma, args[0] = bundle id, args[1] =
 * preference to test</li>
 * <li><b>expected value</b>: the value that the preference is expected to have to
 * evaluate to <code>true</code></li>
 * </ul>
 * 
 * @author Tuukka Lehtonen
 * 
 * @see InstanceScope
 * @see DefaultScope
 */
public class PreferencePropertyTester extends PropertyTester {

    @Override
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        //System.out.println("TEST: " + receiver + ", " + property + ", " + Arrays.toString(args) + ", " + expectedValue);

        if (args.length == 2) {
            String bundle = (String) args[0];
            String preference = (String) args[1];
            String expected = null;
            if (expectedValue instanceof Boolean)
                expected = ((Boolean) expectedValue).toString();
            else
                expected = (String) expectedValue;

            Preferences prefs = InstanceScope.INSTANCE.getNode(bundle);
            String value = prefs.get(preference, null);
            if (value == null) {
                // Get the default value only if there is no instance value.
                prefs = DefaultScope.INSTANCE.getNode(bundle);
                value = prefs.get(preference, null);
            }
            //System.out.println("TESTING VALUE: " + value);
            return ObjectUtils.objectEquals(value, expected);
        }

        return false;
    }

}
