/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.editor;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

/**
 * A class for holding a set of (Object, ResourceEditorAdapter) bindings. These
 * bindings are used to store the latest editor opened for input objects. This
 * is used by the default UI double click actions.
 * 
 * @author Tuukka Lehtonen
 */
public class EditorMappingImpl implements EditorMapping {

    /**
     * Prevent the map from holding on to resource editor adapters.
     */
    WeakHashMap<Object, WeakReference<EditorAdapter>> resourceToAdapter = new WeakHashMap<Object, WeakReference<EditorAdapter>>();

    @Override
    public synchronized void put(Object o, EditorAdapter adapter) {
        assert o != null;
        if (adapter != null) {
            resourceToAdapter.put(o, new WeakReference<EditorAdapter>(adapter));
        } else {
            resourceToAdapter.remove(o);
        }
    }

    @Override
    public synchronized EditorAdapter get(Object o) {
        //System.out.println("EditorMapping.get(" + o + "): key set=" + resourceToAdapter.keySet());
        WeakReference<EditorAdapter> ref = resourceToAdapter.get(o);
        if (ref == null)
            return null;
        EditorAdapter adapter = ref.get();
        if (adapter == null) {
            resourceToAdapter.remove(o);
            return null;
        }
        return adapter;
    }

    @Override
    public synchronized void clear() {
        resourceToAdapter.clear();
    }

}
