package org.simantics.help.ui;

import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.help.HelpResources;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHelpFileAdapter extends AbstractResourceEditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenHelpFileAdapter.class);

    public OpenHelpFileAdapter() {
        super(Messages.OpenHelpFileAdapter_HelpFileEditor);
    }

    protected String getEditorId() {
        return HelpFileEditor.getEditorId();
    }
    
    @Override
    protected boolean canHandle(ReadGraph g, Resource input) throws DatabaseException {
        return g.isInstanceOf(input, HelpResources.getInstance(g).HelpFile);
    }
    
    @Override
    protected void openEditor(Resource input) throws Exception {
        Simantics.getSession().asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph g) throws DatabaseException {

                Variable variable = Variables.getVariable(g, input);
                final Resource model = g.syncRequest(new PossibleIndexRoot(input));
                final RVI rvi = variable.getPossibleRVI(g);
                
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            String editorId = getEditorId();
                            WorkbenchUtils.openEditor(editorId, new ResourceEditorInput2(editorId, input, model, rvi));
                        } catch (PartInitException e) {
                            LOGGER.error("Failed to open an editor for help file.", e); //$NON-NLS-1$
                        }
                    }
                });
            }
        });
    }

}
