package org.simantics.graph.representation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class InputChannel implements ReadableByteChannel {

	private final InputStream stream;

	public InputChannel(InputStream stream) {
		this.stream = stream;
	}

	@Override
	public boolean isOpen() {
		return true;
	}

	@Override
	public void close() throws IOException {
		// NOTE: it is an intentional choice not to close the underlying stream here
		// InputStreams given directly to TransferableGraphFileReader are expected to
		// be closed outside of this implementation.
	}

	@Override
	public int read(ByteBuffer dst) throws IOException {
		int nRead;
		int size = 0;
		int position = dst.position();
		int limit = dst.limit();
		// The users of this channel expect that the data is fully read at this point
		while ((nRead = stream.read(dst.array(), position, limit - position)) != -1 && limit - position > 0) {
			size += nRead;
			position += nRead;
		}
		return size;
	}

}