/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.valve;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.Clickable;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Stateful;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.ElementShapeImpl;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.FixedSize;
import org.simantics.g2d.elementclass.slider.SliderColorProfile;
import org.simantics.g2d.elementclass.slider.SliderHandle;
import org.simantics.g2d.utils.PathUtils;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ValveClass {
    static final double M = 3.0;
    public static final Stroke STROKE = new BasicStroke(1.5f);
    public static final Stroke STROKE2 = new BasicStroke(1.0f);
    public static final Path2D SHAPE = PathUtils.closedPath(-90.0, 60.0, -90.0, -60.0, 0.0, -21.0, 90.0, -60.0, 90.0, 60.0, 0.0, 21.0);
    public static final Path2D WHITE_LINE = PathUtils.path(-90.0, 60.0, -90.0, -60.0, 0.0, -21.0, 90.0, -60.0);
    public static final Path2D BLACK_LINE = PathUtils.path(90.0, -60.0, 90.0, 60.0, 0.0, 21.0, -90.0, 60.0);
    public static final Rectangle2D TRACK_RECT = new Rectangle2D.Double(-81.0, -15.0, 162.0, 30.0);
    public static final Path2D TRACK_WHITE = PathUtils.path(-81.0, 15.0, -81.0, -15.0, 81.0, -15.0);
    public static final Path2D TRACK_BLACK = PathUtils.path(81.0, -15.0, 81.0, 15.0, -81.0, 15.0);
    public static ElementClass INSTANCE = ElementClass.compile(new ValvePainter(), new ValveHandle(), FillColorImpl.handlerOf(new Color(150, 150, 180)), Stateful.ENABLED_BY_DEFAULT, DefaultTransform.INSTANCE, ElementShapeImpl.shapeOf(SHAPE), FixedSize.of(SHAPE.getBounds2D()));

    public static class ValveHandle
    extends SliderHandle
    implements LifeCycle {
        private static final long serialVersionUID = 5605597689550675532L;

        @Override
        protected Rectangle2D getBounds(IElement e) {
            return TRACK_RECT;
        }

        @Override
        protected double getHandleWidth(IElement e) {
            return super.getHandleWidth(e);
        }

        @Override
        public void onElementActivated(IDiagram d, IElement e) {
        }

        @Override
        public void onElementCreated(IElement e) {
            e.setHint(SliderHandle.KEY_SLIDER_COLOR_PROFILE, SliderColorProfile.DEFAULT);
            e.setHint(SliderHandle.KEY_SLIDER_POSITION, 50.0);
            e.setHint(SliderHandle.KEY_SLIDER_MIN_VALUE, 0.0);
            e.setHint(SliderHandle.KEY_SLIDER_MAX_VALUE, 100.0);
        }

        @Override
        public void onElementDeactivated(IDiagram d, IElement e) {
        }

        @Override
        public void onElementDestroyed(IElement e) {
        }
    }

    private static class ValvePainter
    implements SceneGraph {
        private static final long serialVersionUID = -434582053817033874L;
        public static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

        private ValvePainter() {
        }

        @Override
        public void cleanup(IElement e) {
            Node node = (Node)e.removeHint(SG_NODE);
            if (node != null) {
                node.remove();
            }
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            G2DParentNode node = (G2DParentNode)e.getHint(SG_NODE);
            if (node == null) {
                node = (G2DParentNode)parent.addNode(G2DParentNode.class);
                e.setHint(SG_NODE, node);
            }
            Color fc = ElementUtils.getFillColor(e);
            Object press = null;
            AffineTransform at = ElementUtils.getTransform(e);
            if (at != null) {
                node.setTransform(at);
            }
            ShapeNode shape1 = (ShapeNode)node.getOrCreateNode("shape1", ShapeNode.class);
            shape1.setStroke(STROKE);
            shape1.setColor((Paint)fc);
            shape1.setFill(true);
            shape1.setShape((Shape)SHAPE);
            ShapeNode shape_press1 = (ShapeNode)node.getOrCreateNode("shape_press1", ShapeNode.class);
            ShapeNode shape_press2 = (ShapeNode)node.getOrCreateNode("shape_press2", ShapeNode.class);
            if (press == null || press == Clickable.PressStatus.NORMAL || press == Clickable.PressStatus.HOVER) {
                shape_press1.setColor((Paint)Color.WHITE);
                shape_press1.setShape((Shape)WHITE_LINE);
                shape_press2.setColor((Paint)Color.BLACK);
                shape_press2.setShape((Shape)BLACK_LINE);
            } else if (press == Clickable.PressStatus.PRESSED) {
                shape_press1.setColor((Paint)Color.BLACK);
                shape_press1.setShape((Shape)WHITE_LINE);
                shape_press2.setColor((Paint)Color.WHITE);
                shape_press2.setShape((Shape)BLACK_LINE);
            } else if (press == Clickable.PressStatus.HELD) {
                shape_press1.setColor((Paint)new Color(50, 50, 50));
                shape_press1.setShape((Shape)WHITE_LINE);
                shape_press2.setColor((Paint)new Color(240, 240, 240));
                shape_press2.setShape((Shape)BLACK_LINE);
            }
            ShapeNode shape2 = (ShapeNode)node.getOrCreateNode("shape2", ShapeNode.class);
            shape2.setStroke(STROKE2);
            shape2.setColor((Paint)Color.BLACK);
            shape2.setShape((Shape)TRACK_BLACK);
            ShapeNode shape3 = (ShapeNode)node.getOrCreateNode("shape3", ShapeNode.class);
            shape3.setStroke(STROKE2);
            shape3.setColor((Paint)Color.WHITE);
            shape3.setShape((Shape)TRACK_WHITE);
        }
    }
}

