package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer.NonRecursiveSerializer;

public class LongSerializer extends NonRecursiveSerializer {

	LongBinding binding;
	
	public LongSerializer(LongBinding binding) {this.binding = binding;}
	
	@Override
	public Object deserialize(DataInput in) throws IOException{
		try {
			long value = in.readLong(); 
			return binding.create(value);
		} catch (BindingException e) {
			throw new IOException( e ); 
		}
	}

	@Override
	public void deserializeTo(DataInput in, Object obj) throws IOException {
		try {
			binding.setValue(obj, in.readLong());
		} catch (BindingException e) {
			throw new IOException( e ); 
		}
	}
	
	@Override
	public void skip(DataInput in)
			throws IOException {
		in.skipBytes(8);			
	}
	
	@Override
	public void serialize(DataOutput out, Object obj) throws IOException {
		try {
			long value = binding.getValue_(obj);
			out.writeLong( value );
		} catch (BindingException e) {
			throw new IOException( e ); 
		}
	}

	@Override
	public Integer getConstantSize() {
		return 8;
	}

	@Override
	public int getSize(Object obj) {
		return 8;
	}
	
	@Override
	public int getMinSize() {
		return 8;
	}
	
	public long getLong(DataInput in) throws IOException
	{
		return in.readLong();
	}
	
	public void putLong(DataOutput out, long x) throws IOException
	{
		out.writeLong(x);
	}
	
}	
