package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer.NonRecursiveSerializer;

public class IntSerializer  extends NonRecursiveSerializer {

	IntegerBinding binding;
	
	public IntSerializer(IntegerBinding binding) { this.binding = binding; }
	
	@Override
	public Object deserialize(DataInput in) throws IOException {
		try {
			int value = in.readInt();
			return binding.create(value);
		} catch (BindingException e) {
			throw new IOException( e ); 
		}
	}
	
	@Override
	public void deserializeTo(DataInput in, Object obj) throws IOException {
		try {
			binding.setValue(obj, in.readInt());
		} catch (BindingException e) {
			throw new IOException( e ); 
		}
	}
	
	@Override
	public void skip(DataInput in)
			throws IOException {
		in.skipBytes(4);			
	}

	@Override
	public void serialize(DataOutput out, Object obj) throws IOException {
		try {
			int value = binding.getValue_(obj);
			out.writeInt(value);
		} catch (BindingException e) {
			throw new IOException( e ); 
		}
	}

	@Override
	public Integer getConstantSize() {
		return 4;
	}

	@Override
	public int getSize(Object obj) {
		return 4;
	}
	
	@Override
	public int getMinSize() {
		return 4;
	}
	
	public int getInt(DataInput in) throws IOException
	{
		return in.readInt();
	}
	
	public void putInt(DataOutput out, int x) throws IOException
	{
		out.writeInt(x);
	}
	
	
}	
