/* DataParser.java */
/* Generated By:JavaCC: Do not edit this line. DataParser.java */
package org.simantics.databoard.parser;

import org.simantics.databoard.parser.ast.type.*;
import org.simantics.databoard.parser.ast.value.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Collections;

/**
 * Parser for data type definitions.
 * @author Hannu Niemist�
 */
public class DataParser implements DataParserConstants {

/*** Type parser ***************************************************/
  final public 
List<AstTypeDefinition> typeDefinitions() throws ParseException {AstTypeDefinition def;
    List<AstTypeDefinition> result = new ArrayList<AstTypeDefinition>();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 21:{
        ;
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      def = typeDefinition();
result.add(def);
    }
    jj_consume_token(0);
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
  }

  final public AstTypeDefinition typeDefinition() throws ParseException {Token name;
    AstType type;
    jj_consume_token(21);
    name = jj_consume_token(IDENT);
    jj_consume_token(18);
    type = type();
{if ("" != null) return new AstTypeDefinition(name.image, type);}
    throw new Error("Missing return statement in function");
  }

  final public AstType type() throws ParseException {AstType type;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 5:
    case 10:
    case 26:
    case IDENT:{
      type = simpleType();
{if ("" != null) return type;}
      break;
      }
    case 12:{
      type = unionType();
{if ("" != null) return type;}
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public AstType unionType() throws ParseException {List<AstComponent> components = new ArrayList<AstComponent>(4);
    label_2:
    while (true) {
      jj_consume_token(12);
      unionComponent(components);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 12:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
    }
{if ("" != null) return new AstUnionType(components);}
    throw new Error("Missing return statement in function");
  }

  final private void unionComponent(List<AstComponent> components) throws ParseException {Token tag;
    AstType type;
    tag = jj_consume_token(IDENT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 5:
    case 10:
    case 26:
    case IDENT:{
      type = simpleType();
components.add(new AstComponent(tag.image, type));
      break;
      }
    default:
      jj_la1[3] = jj_gen;
components.add(new AstComponent(tag.image, AstRecordType.EMPTY_RECORD));
    }
  }

  final public AstType simpleType() throws ParseException {AstType type;
    type = basicType();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 8:{
        ;
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      jj_consume_token(8);
      type = arraySuffix(type);
    }
{if ("" != null) return type;}
    throw new Error("Missing return statement in function");
  }

  final private AstType arraySuffix(AstType componentType) throws ParseException {Token t1, t2;
    Integer v1;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 9:{
      jj_consume_token(9);
{if ("" != null) return new AstArrayType(componentType, null, null);}
      break;
      }
    case 16:{
      jj_consume_token(16);
      t1 = jj_consume_token(INTEGER);
      jj_consume_token(9);
v1 = Integer.parseInt(t1.image);
        {if ("" != null) return new AstArrayType(componentType, null, v1);}
      break;
      }
    case INTEGER:{
      t1 = jj_consume_token(INTEGER);
v1 = Integer.parseInt(t1.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 9:{
        jj_consume_token(9);
{if ("" != null) return new AstArrayType(componentType, v1, v1);}
        break;
        }
      case 16:{
        jj_consume_token(16);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 9:{
          jj_consume_token(9);
{if ("" != null) return new AstArrayType(componentType, v1, null);}
          break;
          }
        case INTEGER:{
          t2 = jj_consume_token(INTEGER);
          jj_consume_token(9);
{if ("" != null) return new AstArrayType(componentType, v1, Integer.parseInt(t2.image));}
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public AstType basicType() throws ParseException {AstType type;
    boolean referable = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 5:{
      jj_consume_token(5);
      type = tupleType();
      jj_consume_token(6);
{if ("" != null) return type;}
      break;
      }
    case 10:
    case 26:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 26:{
        jj_consume_token(26);
referable=true;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        ;
      }
      jj_consume_token(10);
      type = recordType(referable);
      jj_consume_token(11);
{if ("" != null) return type;}
      break;
      }
    case IDENT:{
      type = typeReference();
{if ("" != null) return type;}
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public AstType typeReference() throws ParseException {Token name;
    List<AstType> parameters = Collections.emptyList();
    List<AstAttribute> attributes = Collections.emptyList();
    name = jj_consume_token(IDENT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 5:{
      jj_consume_token(5);
parameters = new ArrayList<AstType>(2);
          attributes = new ArrayList<AstAttribute>(2);
      parameter(parameters, attributes);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 15:{
          ;
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          break label_4;
        }
        jj_consume_token(15);
        parameter(parameters, attributes);
      }
      jj_consume_token(6);
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
{if ("" != null) return new AstTypeReference(name.image, parameters, attributes);}
    throw new Error("Missing return statement in function");
  }

  final private void parameter(List<AstType> parameters, List<AstAttribute> attributes) throws ParseException {Token key;
    String value;
    AstType type;
    if (jj_2_1(2147483647)) {
      key = jj_consume_token(IDENT);
      jj_consume_token(18);
      value = attributeValue();
attributes.add(new AstAttribute(key.image, value));
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 5:
      case 10:
      case 12:
      case 26:
      case IDENT:{
        type = type();
parameters.add(type);
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public String numericValue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER:
    case FLOAT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case INTEGER:{
        jj_consume_token(INTEGER);
        break;
        }
      case FLOAT:{
        jj_consume_token(FLOAT);
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return token.image;}
      break;
      }
    case 34:{
      jj_consume_token(34);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case INTEGER:{
        jj_consume_token(INTEGER);
        break;
        }
      case FLOAT:{
        jj_consume_token(FLOAT);
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return "-" + token.image;}
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String range() throws ParseException {Token open, close;
  String first = "", second = "";
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 8:{
      jj_consume_token(8);
      break;
      }
    case 5:{
      jj_consume_token(5);
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
open = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER:
    case FLOAT:
    case 34:{
      first = numericValue();
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    jj_consume_token(16);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER:
    case FLOAT:
    case 34:{
      second = numericValue();
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 9:{
      jj_consume_token(9);
      break;
      }
    case 6:{
      jj_consume_token(6);
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
close = token;
{if ("" != null) return open.image + first + ".." + second + close.image;}
    throw new Error("Missing return statement in function");
  }

  final public String attributeValue() throws ParseException {String str;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 22:
    case 23:
    case STRING:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING:{
        jj_consume_token(STRING);
        break;
        }
      case 22:{
        jj_consume_token(22);
        break;
        }
      case 23:{
        jj_consume_token(23);
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return token.image;}
      break;
      }
    case INTEGER:
    case FLOAT:
    case 34:{
      str = numericValue();
{if ("" != null) return str;}
      break;
      }
    case 5:
    case 8:{
      str = range();
{if ("" != null) return str;}
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public AstType tupleType() throws ParseException {AstType type;
  ArrayList<AstType> types;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 5:
    case 10:
    case 12:
    case 26:
    case IDENT:{
      type = type();
types = new ArrayList<AstType>(3); types.add(type);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 15:{
          ;
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          break label_5;
        }
        jj_consume_token(15);
        type = type();
types.add(type);
      }
if(types.size()==1)
            {if ("" != null) return types.get(0);}
        else
            {if ("" != null) return new AstTupleType(types);}
      break;
      }
    default:
      jj_la1[23] = jj_gen;
{if ("" != null) return new AstTupleType(Collections.<AstType>emptyList());}
    }
    throw new Error("Missing return statement in function");
  }

  final public AstType recordType(boolean referable) throws ParseException {AstComponent component;
    ArrayList<AstComponent> components;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 21:
    case 26:
    case IDENT:{
      component = component();
components = new ArrayList<AstComponent>(3); components.add(component);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 15:{
          ;
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          break label_6;
        }
        jj_consume_token(15);
        component = component();
components.add(component);
      }
{if ("" != null) return new AstRecordType(referable, components);}
      break;
      }
    default:
      jj_la1[25] = jj_gen;
{if ("" != null) return new AstRecordType(referable, Collections.<AstComponent>emptyList());}
    }
    throw new Error("Missing return statement in function");
  }

  final public AstComponent component() throws ParseException {Token field;
    AstType type;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      field = jj_consume_token(IDENT);
      break;
      }
    case 21:{
      field = jj_consume_token(21);
      break;
      }
    case 26:{
      field = jj_consume_token(26);
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(14);
    type = type();
{if ("" != null) return new AstComponent(field.image, type);}
    throw new Error("Missing return statement in function");
  }

/*** Value parser **************************************************/
  final public 
List<AstValueDefinition> valueDefinitions() throws ParseException {AstValueDefinition def;
    List<AstValueDefinition> result = new ArrayList<AstValueDefinition>();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        ;
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        break label_7;
      }
      def = valueDefinition();
result.add(def);
    }
    jj_consume_token(0);
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
  }

  final public AstValueDefinition valueDefinition() throws ParseException {Token name;
    AstValue value;
    AstType type;
    name = jj_consume_token(IDENT);
    jj_consume_token(14);
    type = type();
    jj_consume_token(18);
    value = value();
{if ("" != null) return new AstValueDefinition(name.image, type, value);}
    throw new Error("Missing return statement in function");
  }

  final public AstValue value() throws ParseException {AstValue value;
    AstType type;
    value = basicValue();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 14:{
        ;
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_8;
      }
      jj_consume_token(14);
      type = type();
value = new AstVariant(value, type);
    }
{if ("" != null) return value;}
    throw new Error("Missing return statement in function");
  }

  final public AstValue basicValue() throws ParseException {Token tag;
    AstValue temp;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 24:{
      jj_consume_token(24);
{if ("" != null) return AstNull.NULL;}
      break;
      }
    case STRING:{
      jj_consume_token(STRING);
{if ("" != null) return new AstString(token.image);}
      break;
      }
    case LONG_STRING:{
      jj_consume_token(LONG_STRING);
{if ("" != null) return new AstString(token.image);}
      break;
      }
    case INTEGER:{
      jj_consume_token(INTEGER);
{if ("" != null) return new AstInteger(token.image);}
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
{if ("" != null) return new AstFloat(token.image);}
      break;
      }
    case 22:{
      jj_consume_token(22);
{if ("" != null) return AstBoolean.TRUE;}
      break;
      }
    case 23:{
      jj_consume_token(23);
{if ("" != null) return AstBoolean.FALSE;}
      break;
      }
    case 25:{
      jj_consume_token(25);
      jj_consume_token(10);
      temp = map();
      jj_consume_token(11);
{if ("" != null) return temp;}
      break;
      }
    case 8:{
      jj_consume_token(8);
      temp = array();
      jj_consume_token(9);
{if ("" != null) return temp;}
      break;
      }
    case 10:{
      jj_consume_token(10);
      temp = record();
      jj_consume_token(11);
{if ("" != null) return temp;}
      break;
      }
    case 5:{
      jj_consume_token(5);
      temp = tuple();
      jj_consume_token(6);
{if ("" != null) return temp;}
      break;
      }
    case IDENT:{
      tag = jj_consume_token(IDENT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 5:
      case 8:
      case 10:
      case 22:
      case 23:
      case 24:
      case 25:
      case STRING:
      case LONG_STRING:
      case INTEGER:
      case FLOAT:
      case IDENT:{
        temp = basicValue();
{if ("" != null) return new AstTaggedValue(tag.image, temp);}
        break;
        }
      default:
        jj_la1[29] = jj_gen;
{if ("" != null) return new AstReference(tag.image);}
      }
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public AstArray array() throws ParseException {ArrayList<AstValue> components;
    AstValue value;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 5:
    case 8:
    case 10:
    case 22:
    case 23:
    case 24:
    case 25:
    case STRING:
    case LONG_STRING:
    case INTEGER:
    case FLOAT:
    case IDENT:{
components = new ArrayList<AstValue>();
      value = value();
components.add(value);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 15:{
          ;
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          break label_9;
        }
        jj_consume_token(15);
        value = value();
components.add(value);
      }
{if ("" != null) return new AstArray(components);}
      break;
      }
    default:
      jj_la1[32] = jj_gen;
{if ("" != null) return AstArray.EMPTY;}
    }
    throw new Error("Missing return statement in function");
  }

  final public AstValue tuple() throws ParseException {ArrayList<AstValue> components;
    AstValue value;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 5:
    case 8:
    case 10:
    case 22:
    case 23:
    case 24:
    case 25:
    case STRING:
    case LONG_STRING:
    case INTEGER:
    case FLOAT:
    case IDENT:{
components = new ArrayList<AstValue>();
      value = value();
components.add(value);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 15:{
          ;
          break;
          }
        default:
          jj_la1[33] = jj_gen;
          break label_10;
        }
        jj_consume_token(15);
        value = value();
components.add(value);
      }
if(components.size() == 1)
            {if ("" != null) return components.get(0);}
        else
            {if ("" != null) return new AstTuple(components);}
      break;
      }
    default:
      jj_la1[34] = jj_gen;
{if ("" != null) return AstTuple.EMPTY;}
    }
    throw new Error("Missing return statement in function");
  }

  final public AstRecord record() throws ParseException {ArrayList<AstComponentAssignment> components;
    AstComponentAssignment assignment;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
components = new ArrayList<AstComponentAssignment>();
      assignment = assignment();
components.add(assignment);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 15:{
          ;
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          break label_11;
        }
        jj_consume_token(15);
        assignment = assignment();
components.add(assignment);
      }
{if ("" != null) return new AstRecord(components);}
      break;
      }
    default:
      jj_la1[36] = jj_gen;
{if ("" != null) return AstRecord.EMPTY;}
    }
    throw new Error("Missing return statement in function");
  }

  final public AstMap map() throws ParseException {ArrayList<AstMapAssignment> components;
    AstMapAssignment assignment;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 5:
    case 8:
    case 10:
    case 22:
    case 23:
    case 24:
    case 25:
    case STRING:
    case LONG_STRING:
    case INTEGER:
    case FLOAT:
    case IDENT:{
components = new ArrayList<AstMapAssignment>();
      assignment = mapAssignment();
components.add(assignment);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 15:{
          ;
          break;
          }
        default:
          jj_la1[37] = jj_gen;
          break label_12;
        }
        jj_consume_token(15);
        assignment = mapAssignment();
components.add(assignment);
      }
{if ("" != null) return new AstMap(components);}
      break;
      }
    default:
      jj_la1[38] = jj_gen;
{if ("" != null) return AstMap.EMPTY;}
    }
    throw new Error("Missing return statement in function");
  }

  final public AstComponentAssignment assignment() throws ParseException {Token name;
    AstValue value;
    name = jj_consume_token(IDENT);
    jj_consume_token(18);
    value = value();
{if ("" != null) return new AstComponentAssignment(name.image, value);}
    throw new Error("Missing return statement in function");
  }

  final public AstMapAssignment mapAssignment() throws ParseException {AstValue key;
    AstValue value;
    key = value();
    jj_consume_token(18);
    value = value();
{if ("" != null) return new AstMapAssignment(key, value);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(IDENT)) return true;
    if (jj_scan_token(18)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public DataParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[39];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x200000,0x4001420,0x1000,0x4000420,0x100,0x40000200,0x10200,0x40010200,0x4000000,0x4000420,0x8000,0x20,0x4001420,0xc0000000,0xc0000000,0xc0000000,0x120,0xc0000000,0xc0000000,0x240,0x8c00000,0xc8c00120,0x8000,0x4001420,0x8000,0x4200000,0x4200000,0x0,0x4000,0xdbc00520,0xdbc00520,0x8000,0xdbc00520,0x8000,0xdbc00520,0x8000,0x0,0x8000,0xdbc00520,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x4,0x0,0x4,0x4,0x0,0x0,0x4,0x0,0x1,0x0,0x1,0x1,0x1,0x0,0x1,0x1,0x0,0x1,0x0,0x1,0x0,0x1,0x0,0x1,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public DataParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public DataParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new DataParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public DataParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new DataParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new DataParserTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public DataParser(DataParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(DataParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[35];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 39; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 35; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
