/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.method;

import java.util.Set;
import java.util.TreeSet;

/**
 * An interface, a description of methods. 
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class Interface {

	Set<MethodTypeDefinition> methodDefinitions = new TreeSet<MethodTypeDefinition>( MethodTypeDefinition.BINDING );
	
	public Interface()
	{
	}
	
	public Interface(MethodTypeDefinition...methodDefs)
	{		
		for (MethodTypeDefinition def : methodDefs)
		{
			methodDefinitions.add(def);
		}
	}
		
	/**
	 * Add new method definition
	 * 
	 * @param methodDef
	 */
	void add(MethodTypeDefinition methodDef)
	{
		methodDefinitions.add(methodDef);
	}

	/**
	 * Remove method
	 * 
	 * @param methodDef method type definition
	 */
	public void remove(MethodTypeDefinition methodDef)
	{
		if ( !methodDefinitions.remove(methodDef) ) return;
	}

	/**
	 * Get ordered list of method descriptions
	 * 
	 * @return method descriptions
	 */
	public MethodTypeDefinition[] getMethodDefinitions() {
		return methodDefinitions.toArray(new MethodTypeDefinition[methodDefinitions.size()]);
	}
	
	/**
	 * Get ordered list of method descriptions
	 * 
	 * @return method descriptions
	 */
	public Set<MethodTypeDefinition> getMethodDefinitionSet() {
		return methodDefinitions;
	}
	
	@Override
	public String toString() {
		if (methodDefinitions.isEmpty()) return "{}";
		
		StringBuilder sb = new StringBuilder();
		sb.append("{\n");
		for (MethodTypeDefinition def : methodDefinitions) {
			sb.append("  ");
			sb.append(def);
			sb.append("\n");
		}
		sb.append("}");
		return sb.toString();
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Interface == false) return false;
		Interface other = (Interface) obj;
		if (!other.methodDefinitions.equals( methodDefinitions )) return false;
		return true;
	}
	
	@Override
	public int hashCode() {
		int result = 0x3a44a54a;
		for (MethodTypeDefinition def : methodDefinitions)
			result += def.hashCode();
		return result;
	}
	
}

