package org.simantics.databoard.example;

import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;

public class AccessorReference {

	public static void main(String[] args) throws BindingConstructionException, AccessorConstructionException, AccessorException {
		
		
		int[][] data = new int[100][100];
		
		Accessor a = Accessors.getAccessor(data);
		
		// i-4/i-5
		String reference = "i-4/i-5";
		ChildReference ref = ChildReference.parsePath( reference );		
		a.getComponent(ref).setValue(Bindings.INTEGER, 100);		
		System.out.println(data[4][5]);
		
		// 4/5
		reference = "4/5";
		ref = ChildReference.parsePath( reference );		
		a.getComponent(ref).setValue(Bindings.INTEGER, -100);
		System.out.println(data[4][5]);
		
		
	}
	
}
